/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.Identifier;
import brainslug.flow.execution.token.Token;
import brainslug.flow.execution.token.TokenList;
import brainslug.flow.execution.token.TokenStore;
import brainslug.util.IdGenerator;
import brainslug.util.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HashMapTokenStore
implements TokenStore {
    Map<Identifier, List<Identifier>> flowToInstanceMap = Collections.synchronizedMap(new HashMap());
    Map<Identifier, List<Token>> instanceToTokenMap = new HashMap<Identifier, List<Token>>();
    IdGenerator idGenerator;

    public HashMapTokenStore(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public TokenList getInstanceTokens(Identifier instanceId) {
        if (this.instanceToTokenMap.get(instanceId) == null) {
            ArrayList<Token> instanceTokens = new ArrayList<Token>();
            this.instanceToTokenMap.put(instanceId, instanceTokens);
            return new TokenList(instanceTokens);
        }
        return new TokenList(this.instanceToTokenMap.get(instanceId));
    }

    @Override
    public TokenList getNodeTokens(Identifier nodeId, Identifier instanceId) {
        ArrayList<Token> nodeTokens = new ArrayList<Token>();
        Iterator<Token> instanceTokens = this.getInstanceTokens(instanceId).getIterator();
        while (instanceTokens.hasNext()) {
            Token token = instanceTokens.next();
            if (!token.getNodeId().equals(nodeId)) continue;
            nodeTokens.add(token);
        }
        return new TokenList(nodeTokens);
    }

    @Override
    public Token addToken(Identifier instanceId, Identifier nodeId, Option<Identifier> sourceNodeId) {
        Token token = new Token(this.idGenerator.generateId(), nodeId, sourceNodeId, (Option<Identifier>)Option.of((Object)instanceId), false);
        this.getInstanceTokens(instanceId).add(token);
        return token;
    }

    @Override
    public boolean removeToken(Identifier instanceId, Identifier tokenIdToDelete) {
        Iterator<Token> instanceTokens = this.getInstanceTokens(instanceId).getIterator();
        while (instanceTokens.hasNext()) {
            Token nextToken = instanceTokens.next();
            if (!nextToken.getId().equals(tokenIdToDelete)) continue;
            instanceTokens.remove();
            return true;
        }
        return false;
    }

    @Override
    public Identifier createInstance(Identifier definitionId) {
        Identifier instanceId = this.idGenerator.generateId();
        this.getOrCreateInstanceList(definitionId).add(instanceId);
        return instanceId;
    }

    protected List<Identifier> getOrCreateInstanceList(Identifier flowId) {
        if (this.flowToInstanceMap.get(flowId) == null) {
            this.flowToInstanceMap.put(flowId, new ArrayList());
        }
        return this.flowToInstanceMap.get(flowId);
    }
}

