/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.execution.ExecutionContext;
import brainslug.flow.execution.FlowNodeExecutionResult;
import brainslug.flow.execution.TriggerContext;
import brainslug.flow.execution.token.DefaultNodeExecutor;
import brainslug.flow.expression.EqualDefinition;
import brainslug.flow.expression.PredicateDefinition;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.marker.IntermediateEvent;

public class EventNodeExecutor
extends DefaultNodeExecutor<EventDefinition> {
    @Override
    public FlowNodeExecutionResult execute(EventDefinition eventDefinition, ExecutionContext execution) {
        if (this.waitingForSignal(eventDefinition, execution.getTrigger())) {
            return this.takeNone();
        }
        if (!eventDefinition.getPredicateDefinition().isPresent()) {
            return this.takeAll((FlowNodeDefinition<?>)eventDefinition);
        }
        if (this.predicateIsFulfilled((PredicateDefinition)eventDefinition.getPredicateDefinition().get(), execution)) {
            return this.takeAll((FlowNodeDefinition<?>)eventDefinition);
        }
        return this.takeNone();
    }

    protected boolean waitingForSignal(EventDefinition eventDefinition, TriggerContext triggerContext) {
        return eventDefinition.hasMixin(IntermediateEvent.class) && triggerContext.isSignaling() == false;
    }

    protected boolean predicateIsFulfilled(PredicateDefinition eventPredicate, ExecutionContext execution) {
        return execution.getBrainslugContext().getPredicateEvaluator().evaluate((EqualDefinition)eventPredicate, execution);
    }
}

