/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.Identifier;
import brainslug.flow.execution.ExecutionContext;
import brainslug.flow.execution.FlowNodeExecutionResult;
import brainslug.flow.execution.FlowNodeExecutor;
import brainslug.flow.execution.token.Token;
import brainslug.flow.execution.token.TokenStore;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.path.FlowEdgeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultNodeExecutor<T extends FlowNodeDefinition>
implements FlowNodeExecutor<T> {
    protected TokenStore tokenStore;

    public DefaultNodeExecutor<T> withTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        return this;
    }

    @Override
    public FlowNodeExecutionResult execute(T node, ExecutionContext execution) {
        this.consumeAllNodeTokens(execution.getTrigger().getInstanceId(), execution.getTrigger().getNodeId());
        return this.takeAll((FlowNodeDefinition<?>)node);
    }

    protected void consumeAllNodeTokens(Identifier instanceId, Identifier nodeId) {
        Map<Identifier, List<Token>> nodeTokens = this.tokenStore.getNodeTokens(nodeId, instanceId).groupedBySourceNode();
        for (List<Token> tokens : nodeTokens.values()) {
            this.removeTokens(instanceId, tokens);
        }
    }

    protected void removeTokens(Identifier instanceId, List<Token> tokens) {
        for (Token token : tokens) {
            this.tokenStore.removeToken(instanceId, token.getId());
        }
    }

    protected FlowNodeExecutionResult takeAll(FlowNodeDefinition<?> node) {
        ArrayList<FlowNodeDefinition> next = new ArrayList<FlowNodeDefinition>();
        for (FlowEdgeDefinition edge : node.getOutgoing()) {
            next.add(edge.getTarget());
        }
        return new FlowNodeExecutionResult(next);
    }

    protected FlowNodeExecutionResult takeNone() {
        return new FlowNodeExecutionResult(new ArrayList<FlowNodeDefinition>());
    }
}

