/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.execution.async.AbstractRetryStrategy;
import brainslug.flow.execution.async.AsyncTask;
import brainslug.flow.execution.async.AsyncTaskExecutionResult;
import brainslug.flow.execution.async.AsyncTaskExecutor;
import brainslug.flow.execution.async.AsyncTaskQuery;
import brainslug.flow.execution.async.AsyncTaskSchedulerOptions;
import brainslug.flow.execution.async.ExecuteTaskCallable;
import brainslug.flow.node.TaskDefinition;
import brainslug.flow.node.task.RetryStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTasksCallable
implements Callable<List<Future<AsyncTaskExecutionResult>>> {
    private AsyncTaskExecutor asyncTaskExecutor;
    private Logger log = LoggerFactory.getLogger(ExecuteTasksCallable.class);
    BrainslugContext context;
    AsyncTaskSchedulerOptions options;
    ExecutorService taskExecutorService;

    ExecuteTasksCallable(BrainslugContext context, AsyncTaskSchedulerOptions options, ExecutorService taskExecutorService, AsyncTaskExecutor asyncTaskExecutor) {
        this.context = context;
        this.options = options;
        this.taskExecutorService = taskExecutorService;
        this.asyncTaskExecutor = asyncTaskExecutor;
    }

    @Override
    public synchronized List<Future<AsyncTaskExecutionResult>> call() {
        try {
            List<ExecuteTaskCallable> tasksToBeExecuted = this.getTasksToBeExecuted();
            this.log.debug("scheduled tasks for execution: " + tasksToBeExecuted);
            return this.taskExecutorService.invokeAll(tasksToBeExecuted);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("task execution was interrupted", e);
            }
            this.log.error("unable to execute tasks", (Throwable)e);
            throw new RuntimeException("unable to execute tasks: ", e);
        }
    }

    protected List<ExecuteTaskCallable> getTasksToBeExecuted() {
        ArrayList<ExecuteTaskCallable> tasksToBeExecuted = new ArrayList<ExecuteTaskCallable>();
        for (AsyncTask task : this.getTasksToTrigger()) {
            AsyncTask updatedTask = this.context.getAsyncTaskStore().storeTask(task);
            TaskDefinition taskDefinition = (TaskDefinition)this.context.getDefinitionStore().findById(updatedTask.getDefinitionId()).getNode(updatedTask.getTaskNodeId(), TaskDefinition.class);
            tasksToBeExecuted.add(new ExecuteTaskCallable(this.context, updatedTask, this.asyncTaskExecutor, (RetryStrategy)taskDefinition.getRetryStrategy().orElse((Object)AbstractRetryStrategy.quadratic(30L, TimeUnit.SECONDS))));
        }
        return tasksToBeExecuted;
    }

    protected List<AsyncTask> getTasksToTrigger() {
        return this.context.getAsyncTaskStore().getTasks(new AsyncTaskQuery().withMaxCount(this.options.getMaxTaskCount()));
    }
}

