/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.Identifier;
import brainslug.flow.execution.async.AsyncTask;
import brainslug.flow.execution.async.AsyncTaskQuery;
import brainslug.flow.execution.async.AsyncTaskStore;
import brainslug.util.Option;
import java.util.ArrayList;
import java.util.List;

public class ArrayListTaskStore
implements AsyncTaskStore {
    List<AsyncTask> tasks = new ArrayList<AsyncTask>();

    @Override
    public AsyncTask storeTask(AsyncTask asyncTask) {
        if (this.tasks.contains(asyncTask)) {
            return asyncTask.incrementVersion();
        }
        this.tasks.add(asyncTask);
        return asyncTask;
    }

    @Override
    public boolean removeTask(AsyncTask asyncTask) {
        return this.tasks.remove(asyncTask);
    }

    @Override
    public List<AsyncTask> getTasks(AsyncTaskQuery taskQuery) {
        return this.tasks.subList(0, (int)Math.min(taskQuery.maxCount, (long)this.tasks.size()));
    }

    @Override
    public Option<AsyncTask> getTask(Identifier taskNodeId, Identifier instanceId, Identifier definitionId) {
        for (AsyncTask task : this.tasks) {
            if (!task.getTaskNodeId().equals(taskNodeId) || !task.getInstanceId().equals(instanceId) || !task.getDefinitionId().equals(definitionId)) continue;
            return Option.of((Object)task);
        }
        return Option.empty();
    }
}

