/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.extensions.html5player;

import de.agilecoders.wicket.Bootstrap;
import de.agilecoders.wicket.markup.html.bootstrap.common.AbstractConfig;
import de.agilecoders.wicket.markup.html.bootstrap.extensions.html5player.Html5PlayerCssReference;
import de.agilecoders.wicket.markup.html.bootstrap.extensions.html5player.Html5PlayerJavaScriptReference;
import de.agilecoders.wicket.markup.html.bootstrap.extensions.html5player.Html5VideoConfig;
import de.agilecoders.wicket.settings.IBootstrapSettings;
import de.agilecoders.wicket.util.Attributes;
import de.agilecoders.wicket.util.Components;
import de.agilecoders.wicket.util.JQuery;
import de.agilecoders.wicket.util.References;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IClusterable;

public class Html5Player
extends Panel {
    private final IModel<Integer> width;
    private final IModel<Integer> height;
    private final IModel<List<? extends IVideo>> resources;
    private final Html5VideoConfig config;
    private final WebMarkupContainer container;
    private final IModel<String> errorMessage;

    public Html5Player(String markupId, IModel<List<? extends IVideo>> model) {
        this(markupId, model, new Html5VideoConfig());
    }

    public Html5Player(String markupId, IModel<List<? extends IVideo>> model, Html5VideoConfig config) {
        super(markupId, model);
        this.resources = model;
        this.config = config;
        this.width = Model.of((Serializable)Integer.valueOf(370));
        this.height = Model.of((Serializable)Integer.valueOf(215));
        this.errorMessage = Model.of((Serializable)((Object)"Your browser does not support the video tag."));
        Component[] componentArray = new Component[1];
        this.container = this.newVideoTag("video");
        componentArray[0] = this.container;
        this.add(componentArray);
        this.container.add(new Component[]{this.newVideoList("videos")});
        this.container.add(new Component[]{new Label("message", this.errorMessage).setRenderBodyOnly(true)});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Components.assertTag((Component)this, (ComponentTag)tag, (String[])new String[]{"div", "span"});
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"videoUiWrapper", "thumbnail"});
    }

    public Html5Player setWidth(Integer width) {
        this.width.setObject((Object)width);
        return this;
    }

    public Html5Player setHeight(Integer height) {
        this.height.setObject((Object)height);
        return this;
    }

    public Html5Player setErrorMessage(String message) {
        this.errorMessage.setObject((Object)message);
        return this;
    }

    private Component newVideoList(String markupId) {
        return new ListView<IVideo>(markupId, this.resources){

            protected void onInitialize() {
                super.onInitialize();
                this.setRenderBodyOnly(true);
            }

            protected void populateItem(ListItem<IVideo> item) {
                IVideo video = (IVideo)item.getModelObject();
                item.add(new Component[]{new WebMarkupContainer("element").add(new Behavior[]{new AttributeModifier("src", (Serializable)((Object)video.getUrl()))}).add(new Behavior[]{new AttributeModifier("type", (Serializable)((Object)video.getMediaType()))})});
            }
        };
    }

    private WebMarkupContainer newVideoTag(String markupId) {
        return new WebMarkupContainer(markupId){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("width", ((Integer)Html5Player.this.width.getObject()).intValue());
                tag.put("height", ((Integer)Html5Player.this.height.getObject()).intValue());
            }
        };
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)Html5PlayerCssReference.instance()));
        References.renderWithFilter((IBootstrapSettings)Bootstrap.getSettings(), (IHeaderResponse)response, (JavaScriptReferenceHeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)Html5PlayerJavaScriptReference.instance()));
        response.render((HeaderItem)JQuery.$((Component)this.container).chain("videoUI", (AbstractConfig)this.config).asDomReadyScript());
    }

    public static interface IVideo
    extends IClusterable {
        public String getUrl();

        public String getMediaType();
    }
}

