/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.Source;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.BloodhoundConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.Remote;
import de.agilecoders.wicket.jquery.util.Json;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.TextRequestHandler;
import org.apache.wicket.util.string.StringValue;

public abstract class Bloodhound<T>
extends AbstractAjaxBehavior
implements Source<T> {
    private final String name;
    private final BloodhoundConfig config;
    private static final String QUERY_PARAM = "term";

    public Bloodhound(String name) {
        this(name, new BloodhoundConfig());
    }

    public Bloodhound(String name, BloodhoundConfig config) {
        this.name = name;
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Json.RawValue getFunction() {
        return new Json.RawValue(String.format("%s.ttAdapter()", this.name));
    }

    protected void onBind() {
        super.onBind();
        Remote remote = this.config.getRemote();
        if (remote == null) {
            remote = Remote.of(this.getRemoteUrl("%QUERY"));
            this.config.withRemote(remote);
        } else {
            remote.withUrl(this.getRemoteUrl(remote.getWildcard() != null ? remote.getWildcard() : "%QUERY"));
        }
    }

    protected CharSequence getRemoteUrl(String wildcard) {
        return String.format("%s&%s=%s", this.getCallbackUrl(), QUERY_PARAM, wildcard);
    }

    @Override
    public abstract Iterable<T> getChoices(String var1);

    public BloodhoundConfig getConfig() {
        if (this.config != null && this.config.getRemote() != null) {
            Remote remote;
            remote.withUrl(this.getRemoteUrl((remote = this.config.getRemote()).getWildcard() != null ? remote.getWildcard() : "%QUERY"));
        }
        return this.config;
    }

    public void onRequest() {
        RequestCycle requestCycle = this.getComponent().getRequestCycle();
        Request request = requestCycle.getRequest();
        IRequestParameters parameters = request.getRequestParameters();
        StringValue input = parameters.getParameterValue(QUERY_PARAM);
        Iterable<T> choices = this.getChoices(input.toString(""));
        String jsonArray = this.createJson(choices);
        requestCycle.scheduleRequestHandlerAfterCurrent((IRequestHandler)new TextRequestHandler("application/json", "UTF-8", jsonArray));
    }

    protected String createJson(Iterable<T> choices) {
        StringBuilder json = new StringBuilder();
        json.append('[');
        for (T choice : choices) {
            if (json.length() > 1) {
                json.append(',');
            }
            json.append(this.renderChoice(choice));
        }
        json.append(']');
        return json.toString();
    }
}

