/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.util;

import android.util.Xml;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlSerializer;

public class XmlDom {
    private Element root;

    public Element getElement() {
        return this.root;
    }

    public XmlDom(Element element) {
        this.root = element;
    }

    public XmlDom(String str) throws SAXException {
        this(str.getBytes());
    }

    public XmlDom(byte[] data) throws SAXException {
        this(new ByteArrayInputStream(data));
    }

    public XmlDom(InputStream is) throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            this.root = doc.getDocumentElement();
        }
        catch (ParserConfigurationException doc) {
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public XmlDom tag(String tag) {
        NodeList nl = this.root.getElementsByTagName(tag);
        XmlDom result = null;
        if (nl != null && nl.getLength() > 0) {
            result = new XmlDom((Element)nl.item(0));
        }
        return result;
    }

    public XmlDom tag(String tag, String attr, String value) {
        List<XmlDom> tags = this.tags(tag, attr, value);
        if (tags.size() == 0) {
            return null;
        }
        return tags.get(0);
    }

    public List<XmlDom> tags(String tag) {
        return this.tags(tag, null, null);
    }

    public XmlDom child(String tag) {
        return this.child(tag, null, null);
    }

    public XmlDom child(String tag, String attr, String value) {
        List<XmlDom> c = this.children(tag, attr, value);
        if (c.size() == 0) {
            return null;
        }
        return c.get(0);
    }

    public List<XmlDom> children(String tag) {
        return this.children(tag, null, null);
    }

    public List<XmlDom> children(String tag, String attr, String value) {
        return XmlDom.convert(this.root.getChildNodes(), tag, attr, value);
    }

    public List<XmlDom> tags(String tag, String attr, String value) {
        NodeList nl = this.root.getElementsByTagName(tag);
        return XmlDom.convert(nl, null, attr, value);
    }

    private static List<XmlDom> convert(NodeList nl, String tag, String attr, String value) {
        ArrayList<XmlDom> result = new ArrayList<XmlDom>();
        int i = 0;
        while (i < nl.getLength()) {
            XmlDom xml = XmlDom.convert(nl.item(i), tag, attr, value);
            if (xml != null) {
                result.add(xml);
            }
            ++i;
        }
        return result;
    }

    private static XmlDom convert(Node node, String tag, String attr, String value) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element e = (Element)node;
        XmlDom result = null;
        if (!(tag != null && !tag.equals(e.getTagName()) || attr != null && !e.hasAttribute(attr) || value != null && !value.equals(e.getAttribute(attr)))) {
            result = new XmlDom(e);
        }
        return result;
    }

    public String text(String tag) {
        XmlDom dom = this.child(tag);
        if (dom == null) {
            return null;
        }
        return dom.text();
    }

    public String attr(String name) {
        String result = this.root.getAttribute(name);
        return result;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int intentSpaces) {
        return this.serialize(this.root, intentSpaces);
    }

    private String serialize(Element e, int intent) {
        try {
            XmlSerializer s = Xml.newSerializer();
            StringWriter sw = new StringWriter();
            s.setOutput((Writer)sw);
            s.startDocument("utf-8", null);
            String spaces = null;
            if (intent > 0) {
                char[] chars = new char[intent];
                Arrays.fill(chars, ' ');
                spaces = new String(chars);
            }
            this.serialize(this.root, s, 0, spaces);
            s.endDocument();
            return sw.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void writeSpace(XmlSerializer s, int depth, String spaces) throws Exception {
        if (spaces != null) {
            s.text("\n");
            int i = 0;
            while (i < depth) {
                s.text(spaces);
                ++i;
            }
        }
    }

    public String text() {
        NodeList list = this.root.getChildNodes();
        if (list.getLength() == 1) {
            return list.item(0).getNodeValue();
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.getLength()) {
            sb.append(this.text(list.item(i)));
            ++i;
        }
        return sb.toString();
    }

    private String text(Node n) {
        String text = null;
        switch (n.getNodeType()) {
            case 3: {
                text = n.getNodeValue();
                if (text == null) break;
                text = text.trim();
                break;
            }
            case 4: {
                text = n.getNodeValue();
            }
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    private void serialize(Element e, XmlSerializer s, int depth, String spaces) throws Exception {
        String name = e.getTagName();
        this.writeSpace(s, depth, spaces);
        s.startTag("", name);
        if (e.hasAttributes()) {
            NamedNodeMap nm = e.getAttributes();
            int i = 0;
            while (i < nm.getLength()) {
                Attr attr = (Attr)nm.item(i);
                s.attribute("", attr.getName(), attr.getValue());
                ++i;
            }
        }
        if (e.hasChildNodes()) {
            NodeList nl = e.getChildNodes();
            int elements = 0;
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                short type = n.getNodeType();
                switch (type) {
                    case 1: {
                        this.serialize((Element)n, s, depth + 1, spaces);
                        ++elements;
                        break;
                    }
                    case 3: {
                        s.text(this.text(n));
                        break;
                    }
                    case 4: {
                        s.cdsect(this.text(n));
                    }
                }
                ++i;
            }
            if (elements > 0) {
                this.writeSpace(s, depth, spaces);
            }
        }
        s.endTag("", name);
    }
}

