/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.auth;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.androidquery.AQuery;
import com.androidquery.WebDialog;
import com.androidquery.auth.AccountHandle;
import com.androidquery.callback.AbstractAjaxCallback;
import com.androidquery.callback.AjaxStatus;
import com.androidquery.util.AQUtility;
import java.net.HttpURLConnection;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthProvider;
import org.apache.http.HttpRequest;

public class TwitterHandle
extends AccountHandle {
    private static final String OAUTH_REQUEST_TOKEN = "https://api.twitter.com/oauth/request_token";
    private static final String OAUTH_ACCESS_TOKEN = "https://api.twitter.com/oauth/access_token";
    private static final String OAUTH_AUTHORIZE = "https://api.twitter.com/oauth/authorize";
    private static final String CALLBACK_URI = "twitter://callback";
    private static final String CANCEL_URI = "twitter://cancel";
    private Activity act;
    private WebDialog dialog;
    private CommonsHttpOAuthConsumer consumer;
    private CommonsHttpOAuthProvider provider;
    private String token;
    private String secret;
    private static final String TW_TOKEN = "aq.tw.token";
    private static final String TW_SECRET = "aq.tw.secret";

    public TwitterHandle(Activity act, String consumerKey, String consumerSecret) {
        this.act = act;
        this.consumer = new CommonsHttpOAuthConsumer(consumerKey, consumerSecret);
        this.token = this.fetchToken(TW_TOKEN);
        this.secret = this.fetchToken(TW_SECRET);
        if (this.token != null && this.secret != null) {
            this.consumer.setTokenWithSecret(this.token, this.secret);
        }
        this.provider = new CommonsHttpOAuthProvider(OAUTH_REQUEST_TOKEN, OAUTH_ACCESS_TOKEN, OAUTH_AUTHORIZE);
    }

    public String getToken() {
        return this.token;
    }

    public String getSecret() {
        return this.secret;
    }

    private void dismiss() {
        if (this.dialog != null) {
            new AQuery(this.act).dismiss(this.dialog);
            this.dialog = null;
        }
    }

    private void show() {
        if (this.dialog != null) {
            new AQuery(this.act).show(this.dialog);
        }
    }

    private void failure() {
        this.dismiss();
        this.failure((Context)this.act, 401, "cancel");
    }

    @Override
    protected void auth() {
        Task task = new Task();
        task.execute(new String[0]);
    }

    public void authenticate(boolean refreshToken) {
        if (!refreshToken && this.token != null && this.secret != null) {
            this.authenticated(this.secret, this.token);
        } else {
            this.auth();
        }
    }

    protected void authenticated(String secret, String token) {
    }

    private String fetchToken(String key) {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.act).getString(key, null);
    }

    private void storeToken(String key1, String token1, String key2, String token2) {
        PreferenceManager.getDefaultSharedPreferences((Context)this.act).edit().putString(key1, token1).putString(key2, token2).commit();
    }

    private String extract(String url, String param) {
        Uri uri = Uri.parse((String)url);
        String value = uri.getQueryParameter(param);
        return value;
    }

    @Override
    public boolean expired(AbstractAjaxCallback<?, ?> cb, AjaxStatus status) {
        int code = status.getCode();
        return code == 400 || code == 401;
    }

    @Override
    public boolean reauth(AbstractAjaxCallback<?, ?> cb) {
        this.token = null;
        this.secret = null;
        this.storeToken(TW_TOKEN, null, TW_SECRET, null);
        Task task = new Task();
        task.cb = cb;
        AQUtility.post(cb);
        return false;
    }

    @Override
    public void applyToken(AbstractAjaxCallback<?, ?> cb, HttpRequest request) {
        AQUtility.debug("apply token", cb.getUrl());
        try {
            this.consumer.sign((Object)request);
        }
        catch (Exception e) {
            AQUtility.report(e);
        }
    }

    @Override
    public void applyToken(AbstractAjaxCallback<?, ?> cb, HttpURLConnection conn) {
        AQUtility.debug("apply token multipart", cb.getUrl());
        DefaultOAuthConsumer oac = new DefaultOAuthConsumer(this.consumer.getConsumerKey(), this.consumer.getConsumerSecret());
        oac.setTokenWithSecret(this.consumer.getToken(), this.consumer.getTokenSecret());
        try {
            oac.sign((Object)conn);
        }
        catch (Exception e) {
            AQUtility.report(e);
        }
    }

    @Override
    public boolean authenticated() {
        return this.token != null && this.secret != null;
    }

    @Override
    public void unauth() {
        this.token = null;
        this.secret = null;
        CookieSyncManager.createInstance((Context)this.act);
        CookieManager.getInstance().removeAllCookie();
        this.storeToken(TW_TOKEN, null, TW_SECRET, null);
    }

    private class Task
    extends AsyncTask<String, String, String>
    implements DialogInterface.OnCancelListener,
    Runnable {
        private AbstractAjaxCallback<?, ?> cb;

        private Task() {
        }

        protected String doInBackground(String ... params) {
            String url = null;
            try {
                url = TwitterHandle.this.provider.retrieveRequestToken((OAuthConsumer)TwitterHandle.this.consumer, TwitterHandle.CALLBACK_URI);
            }
            catch (Exception e) {
                AQUtility.report(e);
                return null;
            }
            return url;
        }

        protected void onPostExecute(String url) {
            if (url != null) {
                TwitterHandle.this.dialog = new WebDialog((Context)TwitterHandle.this.act, url, new TwWebViewClient());
                TwitterHandle.this.dialog.setOnCancelListener(this);
                TwitterHandle.this.show();
                TwitterHandle.this.dialog.load();
            } else {
                TwitterHandle.this.failure();
            }
        }

        public void onCancel(DialogInterface arg0) {
            TwitterHandle.this.failure();
        }

        @Override
        public void run() {
            TwitterHandle.this.auth(this.cb);
        }
    }

    private class Task2
    extends AsyncTask<String, String, String> {
        private Task2() {
        }

        protected String doInBackground(String ... params) {
            try {
                TwitterHandle.this.provider.retrieveAccessToken((OAuthConsumer)TwitterHandle.this.consumer, params[0]);
            }
            catch (Exception e) {
                AQUtility.report(e);
                return null;
            }
            return "";
        }

        protected void onPostExecute(String url) {
            if (url != null) {
                TwitterHandle.this.token = TwitterHandle.this.consumer.getToken();
                TwitterHandle.this.secret = TwitterHandle.this.consumer.getTokenSecret();
                AQUtility.debug("token", TwitterHandle.this.token);
                AQUtility.debug("secret", TwitterHandle.this.secret);
                TwitterHandle.this.storeToken(TwitterHandle.TW_TOKEN, TwitterHandle.this.token, TwitterHandle.TW_SECRET, TwitterHandle.this.secret);
                TwitterHandle.this.dismiss();
                TwitterHandle.this.success((Context)TwitterHandle.this.act);
                TwitterHandle.this.authenticated(TwitterHandle.this.secret, TwitterHandle.this.token);
            } else {
                TwitterHandle.this.failure();
                TwitterHandle.this.authenticated(null, null);
            }
        }
    }

    private class TwWebViewClient
    extends WebViewClient {
        private TwWebViewClient() {
        }

        private boolean checkDone(String url) {
            if (url.startsWith(TwitterHandle.CALLBACK_URI)) {
                String verf = TwitterHandle.this.extract(url, "oauth_verifier");
                TwitterHandle.this.dismiss();
                Task2 task = new Task2();
                task.execute(new String[]{verf});
                return true;
            }
            if (url.startsWith(TwitterHandle.CANCEL_URI)) {
                TwitterHandle.this.failure();
                return true;
            }
            return false;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return this.checkDone(url);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            AQUtility.debug("started", url);
            if (!this.checkDone(url)) {
                super.onPageStarted(view, url, favicon);
            }
        }

        public void onPageFinished(WebView view, String url) {
            AQUtility.debug("finished", url);
            super.onPageFinished(view, url);
            TwitterHandle.this.show();
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            TwitterHandle.this.failure();
        }
    }
}

