/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.androidquery.util.AQUtility;

public class WebDialog
extends Dialog {
    private String url;
    private WebViewClient client;
    private WebView wv;
    private LinearLayout ll;
    private String message;

    public WebDialog(Context context, String url, WebViewClient client) {
        super(context, 16973830);
        this.url = url;
        this.client = client;
    }

    public void setLoadingMessage(String message) {
        this.message = message;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        RelativeLayout layout = new RelativeLayout(this.getContext());
        layout.setBackgroundColor(-1);
        this.setupWebView(layout);
        this.setupProgress(layout);
        FrameLayout.LayoutParams FILL = new FrameLayout.LayoutParams(-1, -1);
        this.addContentView((View)layout, (ViewGroup.LayoutParams)FILL);
    }

    private void setupProgress(RelativeLayout layout) {
        Context context = this.getContext();
        this.ll = new LinearLayout(context);
        ProgressBar progress = new ProgressBar(context);
        int p = AQUtility.dip2pixel(context, 30.0f);
        LinearLayout.LayoutParams plp = new LinearLayout.LayoutParams(p, p);
        this.ll.addView((View)progress, (ViewGroup.LayoutParams)plp);
        if (this.message != null) {
            TextView tv = new TextView(context);
            LinearLayout.LayoutParams tlp = new LinearLayout.LayoutParams(-2, -2);
            tlp.leftMargin = AQUtility.dip2pixel(context, 5.0f);
            tlp.gravity = 16;
            tv.setText((CharSequence)this.message);
            this.ll.addView((View)tv, (ViewGroup.LayoutParams)tlp);
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        lp.addRule(13);
        layout.addView((View)this.ll, (ViewGroup.LayoutParams)lp);
    }

    private void setupWebView(RelativeLayout layout) {
        this.wv = new WebView(this.getContext());
        this.wv.setVerticalScrollBarEnabled(false);
        this.wv.setHorizontalScrollBarEnabled(false);
        if (this.client == null) {
            this.client = new WebViewClient();
        }
        this.wv.setWebViewClient((WebViewClient)new DialogWebViewClient());
        WebSettings ws = this.wv.getSettings();
        ws.setJavaScriptEnabled(true);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        layout.addView((View)this.wv, (ViewGroup.LayoutParams)lp);
    }

    public void load() {
        if (this.wv != null) {
            this.wv.loadUrl(this.url);
        }
    }

    private void showProgress(boolean show) {
        if (this.ll != null) {
            if (show) {
                this.ll.setVisibility(0);
            } else {
                this.ll.setVisibility(8);
            }
        }
    }

    public void dismiss() {
        try {
            super.dismiss();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class DialogWebViewClient
    extends WebViewClient {
        private DialogWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            WebDialog.this.showProgress(false);
            WebDialog.this.client.onPageFinished(view, url);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            WebDialog.this.client.onPageStarted(view, url, favicon);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            WebDialog.this.client.onReceivedError(view, errorCode, description, failingUrl);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return WebDialog.this.client.shouldOverrideUrlLoading(view, url);
        }
    }
}

