/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.util;

import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.PersonIdent;
import com.xenoterracide.gradle.semver.jgit.lib.SignatureVerifier;
import com.xenoterracide.gradle.semver.jgit.util.GitDateFormatter;
import com.xenoterracide.gradle.semver.jgit.util.StringUtils;
import java.text.MessageFormat;
import java.util.Locale;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static String toString(SignatureVerifier.SignatureVerification verification, PersonIdent creator, GitDateFormatter formatter) {
        StringBuilder result = new StringBuilder();
        if (verification.creationDate() != null) {
            PersonIdent dateId = new PersonIdent(creator, verification.creationDate().toInstant());
            result.append(MessageFormat.format(JGitText.get().verifySignatureMade, formatter.formatDate(dateId)));
            result.append('\n');
        }
        result.append(MessageFormat.format(JGitText.get().verifySignatureKey, verification.keyFingerprint().toUpperCase(Locale.ROOT)));
        result.append('\n');
        if (!StringUtils.isEmptyOrNull(verification.signer())) {
            result.append(MessageFormat.format(JGitText.get().verifySignatureIssuer, verification.signer()));
            result.append('\n');
        }
        String msg = verification.verified() ? (verification.expired() ? JGitText.get().verifySignatureExpired : JGitText.get().verifySignatureGood) : JGitText.get().verifySignatureBad;
        result.append(MessageFormat.format(msg, verification.keyUser()));
        if (!SignatureVerifier.TrustLevel.UNKNOWN.equals((Object)verification.trustLevel())) {
            result.append(" " + MessageFormat.format(JGitText.get().verifySignatureTrust, verification.trustLevel().name().toLowerCase(Locale.ROOT)));
        }
        result.append('\n');
        msg = verification.message();
        if (!StringUtils.isEmptyOrNull(msg)) {
            result.append(msg);
            result.append('\n');
        }
        return result.toString();
    }
}

