/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport.http;

import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.transport.http.DelegatingSSLSocketFactory;
import com.xenoterracide.gradle.semver.jgit.transport.http.HttpConnection;
import com.xenoterracide.gradle.semver.jgit.transport.http.HttpConnectionFactory2;
import com.xenoterracide.gradle.semver.jgit.transport.http.JDKHttpConnection;
import com.xenoterracide.gradle.semver.jgit.transport.http.NoCheckX509TrustManager;
import com.xenoterracide.gradle.semver.jgit.util.HttpSupport;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class JDKHttpConnectionFactory
implements HttpConnectionFactory2 {
    @Override
    public HttpConnection create(URL url) throws IOException {
        return new JDKHttpConnection(url);
    }

    @Override
    public HttpConnection create(URL url, Proxy proxy) throws IOException {
        return new JDKHttpConnection(url, proxy);
    }

    @Override
    public HttpConnectionFactory2.GitSession newSession() {
        return new JdkConnectionSession();
    }

    private static class JdkConnectionSession
    implements HttpConnectionFactory2.GitSession {
        private SSLContext securityContext;
        private SSLSocketFactory socketFactory;

        private JdkConnectionSession() {
        }

        @Override
        public JDKHttpConnection configure(HttpConnection connection, boolean sslVerify) throws GeneralSecurityException {
            if (!(connection instanceof JDKHttpConnection)) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().httpWrongConnectionType, JDKHttpConnection.class.getName(), connection.getClass().getName()));
            }
            JDKHttpConnection conn = (JDKHttpConnection)connection;
            String scheme = conn.getURL().getProtocol();
            if (!"https".equals(scheme) || sslVerify) {
                return conn;
            }
            if (this.securityContext == null) {
                this.securityContext = SSLContext.getInstance("TLS");
                TrustManager[] trustAllCerts = new TrustManager[]{new NoCheckX509TrustManager()};
                this.securityContext.init(null, trustAllCerts, null);
                this.socketFactory = new DelegatingSSLSocketFactory(this.securityContext.getSocketFactory()){

                    @Override
                    protected void configure(SSLSocket socket) {
                        HttpSupport.configureTLS(socket);
                    }
                };
            }
            conn.setHostnameVerifier((name, session) -> true);
            ((HttpsURLConnection)conn.wrappedUrlConnection).setSSLSocketFactory(this.socketFactory);
            return conn;
        }

        @Override
        public void close() {
            this.securityContext = null;
            this.socketFactory = null;
        }
    }
}

