/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.revwalk.filter;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevFlag;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevFlagSet;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.revwalk.filter.RevFilter;
import java.io.IOException;
import java.util.Arrays;

public abstract class RevFlagFilter
extends RevFilter {
    final RevFlagSet flags;

    public static RevFilter has(RevFlag a) {
        RevFlagSet s = new RevFlagSet();
        s.add(a);
        return new HasAll(s);
    }

    public static RevFilter hasAll(RevFlag ... a) {
        RevFlagSet set = new RevFlagSet();
        set.addAll(Arrays.asList(a));
        return new HasAll(set);
    }

    public static RevFilter hasAll(RevFlagSet a) {
        return new HasAll(new RevFlagSet(a));
    }

    public static RevFilter hasAny(RevFlag ... a) {
        RevFlagSet set = new RevFlagSet();
        set.addAll(Arrays.asList(a));
        return new HasAny(set);
    }

    public static RevFilter hasAny(RevFlagSet a) {
        return new HasAny(new RevFlagSet(a));
    }

    RevFlagFilter(RevFlagSet m) {
        this.flags = m;
    }

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + String.valueOf(this.flags);
    }

    private static class HasAll
    extends RevFlagFilter {
        HasAll(RevFlagSet m) {
            super(m);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return c.hasAll(this.flags);
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }
    }

    private static class HasAny
    extends RevFlagFilter {
        HasAny(RevFlagSet m) {
            super(m);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return c.hasAny(this.flags);
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }
    }
}

