/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.revwalk.filter;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.errors.StopWalkException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

public class MaxCountRevFilter
extends RevFilter {
    private int maxCount;
    private int count = 0;

    public static RevFilter create(int maxCount) {
        if (maxCount < 0) {
            throw new IllegalArgumentException(JGitText.get().maxCountMustBeNonNegative);
        }
        return new MaxCountRevFilter(maxCount);
    }

    private MaxCountRevFilter(int maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        ++this.count;
        if (this.count > this.maxCount) {
            throw StopWalkException.INSTANCE;
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new MaxCountRevFilter(this.maxCount);
    }
}

