/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.revwalk;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.revwalk.BlockRevQueue;
import com.xenoterracide.gradle.semver.jgit.revwalk.Generator;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import java.io.IOException;

public class FIFORevQueue
extends BlockRevQueue {
    private BlockRevQueue.Block head;
    private BlockRevQueue.Block tail;

    public FIFORevQueue() {
        super(false);
    }

    FIFORevQueue(boolean firstParent) {
        super(firstParent);
    }

    FIFORevQueue(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s);
    }

    @Override
    public void add(RevCommit c) {
        BlockRevQueue.Block b = this.tail;
        if (b == null) {
            b = this.free.newBlock();
            b.add(c);
            this.head = b;
            this.tail = b;
            return;
        }
        if (b.isFull()) {
            this.tail.next = b = this.free.newBlock();
            this.tail = b;
        }
        b.add(c);
    }

    public void unpop(RevCommit c) {
        BlockRevQueue.Block b = this.head;
        if (b == null) {
            b = this.free.newBlock();
            b.resetToMiddle();
            b.add(c);
            this.head = b;
            this.tail = b;
            return;
        }
        if (b.canUnpop()) {
            b.unpop(c);
            return;
        }
        b = this.free.newBlock();
        b.resetToEnd();
        b.unpop(c);
        b.next = this.head;
        this.head = b;
    }

    @Override
    public RevCommit next() {
        BlockRevQueue.Block b = this.head;
        if (b == null) {
            return null;
        }
        RevCommit c = b.pop();
        if (b.isEmpty()) {
            this.head = b.next;
            if (this.head == null) {
                this.tail = null;
            }
            this.free.freeBlock(b);
        }
        return c;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.free.clear();
    }

    @Override
    boolean everbodyHasFlag(int f) {
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            int i = b.headIndex;
            while (i < b.tailIndex) {
                if ((b.commits[i].flags & f) == 0) {
                    return false;
                }
                ++i;
            }
            b = b.next;
        }
        return true;
    }

    @Override
    boolean anybodyHasFlag(int f) {
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            int i = b.headIndex;
            while (i < b.tailIndex) {
                if ((b.commits[i].flags & f) != 0) {
                    return true;
                }
                ++i;
            }
            b = b.next;
        }
        return false;
    }

    void removeFlag(int f) {
        int not_f = ~f;
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            int i = b.headIndex;
            while (i < b.tailIndex) {
                b.commits[i].flags &= not_f;
                ++i;
            }
            b = b.next;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        BlockRevQueue.Block q = this.head;
        while (q != null) {
            int i = q.headIndex;
            while (i < q.tailIndex) {
                FIFORevQueue.describe(s, q.commits[i]);
                ++i;
            }
            q = q.next;
        }
        return s.toString();
    }
}

