/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.file;

import com.xenoterracide.gradle.semver.jgit.internal.storage.file.LockFile;
import com.xenoterracide.gradle.semver.jgit.lib.Constants;
import com.xenoterracide.gradle.semver.jgit.transport.PackLock;
import com.xenoterracide.gradle.semver.jgit.util.FS;
import com.xenoterracide.gradle.semver.jgit.util.FileUtils;
import java.io.File;
import java.io.IOException;

public class PackLockImpl
implements PackLock {
    private final File keepFile;

    public PackLockImpl(File packFile, FS fs) {
        File p = packFile.getParentFile();
        String n = packFile.getName();
        this.keepFile = new File(p, n.substring(0, n.length() - 5) + ".keep");
    }

    public boolean lock(String msg) throws IOException {
        LockFile lf;
        if (msg == null) {
            return false;
        }
        if (!((String)msg).endsWith("\n")) {
            msg = (String)msg + "\n";
        }
        if (!(lf = new LockFile(this.keepFile)).lock()) {
            return false;
        }
        lf.write(Constants.encode((String)msg));
        return lf.commit();
    }

    @Override
    public void unlock() throws IOException {
        FileUtils.delete(this.keepFile);
    }
}

