/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.diffmergetool;

import com.xenoterracide.gradle.semver.jgit.internal.diffmergetool.ExternalDiffTool;
import com.xenoterracide.gradle.semver.jgit.internal.diffmergetool.UserDefinedDiffTool;
import com.xenoterracide.gradle.semver.jgit.lib.Config;
import com.xenoterracide.gradle.semver.jgit.lib.internal.BooleanTriState;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DiffToolConfig {
    public static final Config.SectionParser<DiffToolConfig> KEY = DiffToolConfig::new;
    private final String toolName;
    private final String guiToolName;
    private final boolean prompt;
    private final BooleanTriState trustExitCode;
    private final Map<String, ExternalDiffTool> tools;

    private DiffToolConfig(Config rc) {
        this.toolName = rc.getString("diff", null, "tool");
        this.guiToolName = rc.getString("diff", null, "guitool");
        this.prompt = rc.getBoolean("difftool", this.toolName, "prompt", true);
        String trustStr = rc.getString("difftool", this.toolName, "trustExitCode");
        this.trustExitCode = trustStr != null ? (Boolean.parseBoolean(trustStr) ? BooleanTriState.TRUE : BooleanTriState.FALSE) : BooleanTriState.UNSET;
        this.tools = new HashMap<String, ExternalDiffTool>();
        Set<String> subsections = rc.getSubsections("difftool");
        for (String name : subsections) {
            String cmd = rc.getString("difftool", name, "cmd");
            String path = rc.getString("difftool", name, "path");
            if (cmd == null && path == null) continue;
            this.tools.put(name, new UserDefinedDiffTool(name, path, cmd));
        }
    }

    public String getDefaultToolName() {
        return this.toolName;
    }

    public String getDefaultGuiToolName() {
        return this.guiToolName;
    }

    public boolean isPrompt() {
        return this.prompt;
    }

    public boolean isTrustExitCode() {
        return this.trustExitCode == BooleanTriState.TRUE;
    }

    public Map<String, ExternalDiffTool> getTools() {
        return this.tools;
    }

    public Set<String> getToolNames() {
        return this.tools.keySet();
    }
}

