/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.hooks;

import com.xenoterracide.gradle.semver.jgit.api.errors.AbortedByHookException;
import com.xenoterracide.gradle.semver.jgit.hooks.GitHook;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class CommitMsgHook
extends GitHook<String> {
    public static final String NAME = "commit-msg";
    private String commitMessage;

    protected CommitMsgHook(Repository repo, PrintStream outputStream) {
        super(repo, outputStream);
    }

    protected CommitMsgHook(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        super(repo, outputStream, errorStream);
    }

    @Override
    public String call() throws IOException, AbortedByHookException {
        if (this.commitMessage == null) {
            throw new IllegalStateException();
        }
        if (this.canRun()) {
            this.getRepository().writeCommitEditMsg(this.commitMessage);
            this.doRun();
            this.commitMessage = this.getRepository().readCommitEditMsg();
        }
        return this.commitMessage;
    }

    private boolean canRun() {
        return this.getCommitEditMessageFilePath() != null && this.commitMessage != null;
    }

    @Override
    public String getHookName() {
        return NAME;
    }

    @Override
    protected String[] getParameters() {
        return new String[]{this.getCommitEditMessageFilePath()};
    }

    private String getCommitEditMessageFilePath() {
        File gitDir = this.getRepository().getDirectory();
        if (gitDir == null) {
            return null;
        }
        return Repository.stripWorkDir(this.getRepository().getWorkTree(), new File(gitDir, "COMMIT_EDITMSG"));
    }

    public CommitMsgHook setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
        return this;
    }
}

