/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.StoredConfig;
import com.xenoterracide.gradle.semver.jgit.transport.RemoteConfig;
import com.xenoterracide.gradle.semver.jgit.transport.URIish;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public class RemoteSetUrlCommand
extends GitCommand<RemoteConfig> {
    private String remoteName;
    private URIish remoteUri;
    private UriType type;

    protected RemoteSetUrlCommand(Repository repo) {
        super(repo);
    }

    public RemoteSetUrlCommand setRemoteName(String remoteName) {
        this.remoteName = remoteName;
        return this;
    }

    public RemoteSetUrlCommand setRemoteUri(URIish remoteUri) {
        this.remoteUri = remoteUri;
        return this;
    }

    public RemoteSetUrlCommand setUriType(UriType type) {
        this.type = type;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.remoteName);
            if (this.type == UriType.PUSH) {
                List<URIish> uris = remote.getPushURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.pushurl has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removePushURI(uris.get(0));
                }
                remote.addPushURI(this.remoteUri);
            } else {
                List<URIish> uris = remote.getURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.url has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removeURI(uris.get(0));
                }
                remote.addURI(this.remoteUri);
            }
            remote.update(config);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public static enum UriType {
        FETCH,
        PUSH;

    }
}

