/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.blame.BlameGenerator;
import com.xenoterracide.gradle.semver.jgit.blame.BlameResult;
import com.xenoterracide.gradle.semver.jgit.diff.DiffAlgorithm;
import com.xenoterracide.gradle.semver.jgit.diff.RawTextComparator;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class BlameCommand
extends GitCommand<BlameResult> {
    private String path;
    private DiffAlgorithm diffAlgorithm;
    private RawTextComparator textComparator;
    private ObjectId startCommit;
    private Collection<ObjectId> reverseEndCommits;
    private Boolean followFileRenames;

    public BlameCommand(Repository repo) {
        super(repo);
    }

    public BlameCommand setFilePath(String filePath) {
        this.path = filePath;
        return this;
    }

    public BlameCommand setDiffAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
        return this;
    }

    public BlameCommand setTextComparator(RawTextComparator textComparator) {
        this.textComparator = textComparator;
        return this;
    }

    public BlameCommand setStartCommit(AnyObjectId commit) {
        this.startCommit = commit.toObjectId();
        return this;
    }

    public BlameCommand setFollowFileRenames(boolean follow) {
        this.followFileRenames = follow;
        return this;
    }

    public BlameCommand reverse(AnyObjectId start, AnyObjectId end) throws IOException {
        return this.reverse(start, Collections.singleton(end.toObjectId()));
    }

    public BlameCommand reverse(AnyObjectId start, Collection<ObjectId> end) throws IOException {
        this.startCommit = start.toObjectId();
        this.reverseEndCommits = new ArrayList<ObjectId>(end);
        return this;
    }

    @Override
    public BlameResult call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BlameGenerator gen = new BlameGenerator(this.repo, this.path);){
                if (this.diffAlgorithm != null) {
                    gen.setDiffAlgorithm(this.diffAlgorithm);
                }
                if (this.textComparator != null) {
                    gen.setTextComparator(this.textComparator);
                }
                if (this.followFileRenames != null) {
                    gen.setFollowFileRenames(this.followFileRenames);
                }
                if (this.reverseEndCommits != null) {
                    gen.reverse((AnyObjectId)this.startCommit, this.reverseEndCommits);
                } else if (this.startCommit != null) {
                    gen.push(null, this.startCommit);
                } else {
                    gen.prepareHead();
                }
                return gen.computeBlameResult();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

