/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.git;

import com.xenoterracide.gradle.git.Describer;
import com.xenoterracide.gradle.git.GitMetadataImpl;
import com.xenoterracide.gradle.git.IterableTools;
import com.xenoterracide.gradle.git.TryGit;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DistanceCalculator
implements Function<String, Long> {
    private final TryGit git;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    DistanceCalculator(TryGit git) {
        this.git = git;
    }

    long distanceFromNoTag(ObjectId oid) {
        return (Long)this.git.tryCommand((CheckedFunction1 & Serializable)g -> g.log().add(oid).all()).map(IterableTools::of).map(Stream::count).recover(NoSuchElementException.class, (Object)0L).recover(GitMetadataImpl.allWith(0L)).onFailure(e -> this.log.error("failed to get distance without a tag", e)).get();
    }

    long distance(ObjectId oid) {
        return (Long)this.git.tryGit(Describer.describe(oid)).map(Describer.Described::distance).recover(NoSuchElementException.class, e -> this.distanceFromNoTag(oid)).onFailure(e -> this.log.error("failed to get distance", e)).getOrElse((Object)0L);
    }

    @Override
    public Long apply(String revString) {
        ObjectId rev = (ObjectId)this.git.tryGit((CheckedFunction1 & Serializable)git -> git.getRepository().resolve(revString)).getOrElse(() -> null);
        if (rev == null) {
            return 0L;
        }
        return this.distance(rev);
    }
}

