/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class FlowModeAbstractMojo
extends AbstractMojo
implements PluginAdapterBase {
    public static final String INCLUDE_FROM_COMPILE_DEPS_REGEX = ".*(/|\\\\)(portlet-api|javax\\.servlet-api)-.+jar$";
    @Parameter(defaultValue="${project.basedir}/src/main/resources/application.properties")
    private File applicationProperties;
    @Parameter(defaultValue="${vaadin.eagerServerLoad}")
    private boolean eagerServerLoad;
    @Parameter(defaultValue="${project.basedir}/src/main/frontend/")
    private File frontendDirectory;
    @Parameter(defaultValue="${null}")
    private File generatedTsFolder;
    @Parameter(defaultValue="${project.basedir}/src/main/java")
    private File javaSourceFolder;
    @Parameter(defaultValue="${project.basedir}/src/main/resources")
    private File javaResourceFolder;
    @Parameter(property="node.download.root")
    private String nodeDownloadRoot;
    @Parameter(property="node.version", defaultValue="v20.18.0")
    private String nodeVersion;
    @Parameter(property="node.auto.update", defaultValue="true")
    private boolean nodeAutoUpdate;
    @Parameter(defaultValue="${project.basedir}")
    private File npmFolder;
    @Parameter(defaultValue="${project.build.directory}/generated-resources/openapi.json")
    private File openApiJsonFile;
    @Parameter(property="pnpm.enable", defaultValue="false")
    private boolean pnpmEnable;
    @Parameter(property="bun.enable", defaultValue="false")
    private boolean bunEnable;
    @Parameter(property="pnpm.global", defaultValue="false")
    private boolean useGlobalPnpm;
    @Parameter(defaultValue="${null}")
    protected Boolean productionMode;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    private File projectBasedir;
    @Parameter(property="require.home.node", defaultValue="false")
    private boolean requireHomeNodeExec;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/VAADIN/")
    private File resourceOutputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/VAADIN/webapp/")
    private File webpackOutputDirectory;
    @Parameter(property="build.folder", defaultValue="${project.build.directory}")
    private String projectBuildDir;
    @Parameter(property="npm.postinstallPackages", defaultValue="")
    private List<String> postinstallPackages;
    @Parameter(property="frontend.hotdeploy", defaultValue="${null}")
    private Boolean frontendHotdeploy;
    @Parameter(property="vaadin.skip.dev.bundle", defaultValue="false")
    private boolean skipDevBundleRebuild;
    @Parameter(property="react.enable", defaultValue="${null}")
    private Boolean reactEnable;
    @Parameter(property="applicationIdentifier")
    private String applicationIdentifier;
    private ClassFinder classFinder;

    public static List<String> getClasspathElements(MavenProject project) {
        try {
            Stream classpathElements = Stream.of(project.getRuntimeClasspathElements().stream(), project.getSystemClasspathElements().stream(), project.getCompileClasspathElements().stream().filter(s -> s.matches(INCLUDE_FROM_COMPILE_DEPS_REGEX))).flatMap(Function.identity());
            return classpathElements.collect(Collectors.toList());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException(String.format("Failed to retrieve runtime classpath elements from project '%s'", project), e);
        }
    }

    public boolean isHillaAvailable() {
        return this.getClassFinder().getResource("com/vaadin/hilla/EndpointController.class") != null;
    }

    public static boolean isHillaAvailable(MavenProject mavenProject) {
        return FlowModeAbstractMojo.createClassFinder(mavenProject).getResource("com/vaadin/hilla/EndpointController.class") != null;
    }

    public boolean isHillaUsed(File frontendDirectory) {
        return this.isHillaAvailable() && FrontendUtils.isHillaViewsUsed((File)frontendDirectory);
    }

    public static boolean isHillaUsed(MavenProject mavenProject, File frontendDirectory) {
        return FlowModeAbstractMojo.isHillaAvailable(mavenProject) && FrontendUtils.isHillaViewsUsed((File)frontendDirectory);
    }

    public File applicationProperties() {
        return this.applicationProperties;
    }

    public boolean eagerServerLoad() {
        return this.eagerServerLoad;
    }

    public File frontendDirectory() {
        return this.frontendDirectory;
    }

    public File generatedTsFolder() {
        if (this.generatedTsFolder != null) {
            return this.generatedTsFolder;
        }
        return new File(this.frontendDirectory(), "generated/");
    }

    public ClassFinder getClassFinder() {
        if (this.classFinder == null) {
            this.classFinder = FlowModeAbstractMojo.createClassFinder(this.project);
        }
        return this.classFinder;
    }

    private static ClassFinder createClassFinder(MavenProject project) {
        List<String> classpathElements = FlowModeAbstractMojo.getClasspathElements(project);
        return BuildFrontendUtil.getClassFinder(classpathElements);
    }

    public Set<File> getJarFiles() {
        return this.project.getArtifacts().stream().filter(artifact -> "jar".equals(artifact.getType())).map(Artifact::getFile).collect(Collectors.toSet());
    }

    public boolean isDebugEnabled() {
        return this.getLog().isDebugEnabled();
    }

    public File javaSourceFolder() {
        return this.javaSourceFolder;
    }

    public File javaResourceFolder() {
        return this.javaResourceFolder;
    }

    public void logDebug(CharSequence debugMessage) {
        this.getLog().debug(debugMessage);
    }

    public void logDebug(CharSequence debugMessage, Throwable e) {
        this.getLog().debug(debugMessage, e);
    }

    public void logInfo(CharSequence infoMessage) {
        this.getLog().info(infoMessage);
    }

    public void logWarn(CharSequence warning) {
        this.getLog().warn(warning);
    }

    public void logError(CharSequence error) {
        this.getLog().error(error);
    }

    public void logWarn(CharSequence warning, Throwable e) {
        this.getLog().warn(warning, e);
    }

    public void logError(CharSequence error, Throwable e) {
        this.getLog().error(error, e);
    }

    public URI nodeDownloadRoot() throws URISyntaxException {
        if (this.nodeDownloadRoot == null) {
            this.nodeDownloadRoot = Platform.guess().getNodeDownloadRoot();
        }
        try {
            return new URI(this.nodeDownloadRoot);
        }
        catch (URISyntaxException e) {
            this.logError("Failed to parse nodeDownloadRoot uri", e);
            throw new URISyntaxException(this.nodeDownloadRoot, "Failed to parse nodeDownloadRoot uri");
        }
    }

    public boolean nodeAutoUpdate() {
        return this.nodeAutoUpdate;
    }

    public String nodeVersion() {
        return this.nodeVersion;
    }

    public File npmFolder() {
        return this.npmFolder;
    }

    public File openApiJsonFile() {
        return this.openApiJsonFile;
    }

    public boolean pnpmEnable() {
        return this.pnpmEnable;
    }

    public boolean bunEnable() {
        return this.bunEnable;
    }

    public boolean useGlobalPnpm() {
        return this.useGlobalPnpm;
    }

    public Path projectBaseDirectory() {
        return this.projectBasedir.toPath();
    }

    public boolean requireHomeNodeExec() {
        return this.requireHomeNodeExec;
    }

    public File servletResourceOutputDirectory() {
        return this.resourceOutputDirectory;
    }

    public File webpackOutputDirectory() {
        return this.webpackOutputDirectory;
    }

    public boolean isJarProject() {
        return "jar".equals(this.project.getPackaging());
    }

    public String buildFolder() {
        if (this.projectBuildDir.startsWith(this.projectBasedir.toString())) {
            return this.projectBaseDirectory().relativize(Paths.get(this.projectBuildDir, new String[0])).toString();
        }
        return this.projectBuildDir;
    }

    public List<String> postinstallPackages() {
        return this.postinstallPackages;
    }

    public boolean isFrontendHotdeploy() {
        if (this.frontendHotdeploy != null) {
            return this.frontendHotdeploy;
        }
        File frontendDirectory = BuildFrontendUtil.getFrontendDirectory((PluginAdapterBase)this);
        return this.isHillaUsed(frontendDirectory);
    }

    public boolean skipDevBundleBuild() {
        return this.skipDevBundleRebuild;
    }

    public boolean isPrepareFrontendCacheDisabled() {
        return false;
    }

    public boolean isReactEnabled() {
        if (this.reactEnable != null) {
            return this.reactEnable;
        }
        File frontendDirectory = BuildFrontendUtil.getFrontendDirectory((PluginAdapterBase)this);
        return FrontendUtils.isReactRouterRequired((File)frontendDirectory);
    }

    public String applicationIdentifier() {
        if (this.applicationIdentifier != null && !this.applicationIdentifier.isBlank()) {
            return this.applicationIdentifier;
        }
        return "app-" + StringUtil.getHash((String)(this.project.getGroupId() + ":" + this.project.getArtifactId()), (Charset)StandardCharsets.UTF_8);
    }
}

