/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dnd.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.dnd.DragSource;
import com.vaadin.flow.component.dnd.DropTarget;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@NpmPackage(value="mobile-drag-drop", version="2.3.0-rc.2")
public class DndUtil {
    public static final String DND_CONNECTOR = "./dndConnector.js";
    public static final String EFFECT_ALLOWED_ELEMENT_PROPERTY = "__effectAllowed";
    public static final String DRAG_SOURCE_DATA_KEY = "drag-source-data";
    public static final String START_LISTENER_REGISTRATION_KEY = "_startListenerRegistration";
    public static final String END_LISTENER_REGISTRATION_KEY = "_endListenerRegistration";
    public static final String DROP_TARGET_ACTIVE_PROPERTY = "__active";
    public static final String DROP_EFFECT_ELEMENT_PROPERTY = "__dropEffect";
    private static final String DETACH_LISTENER_FOR_DROP_TARGET = "_detachListenerForDropTarget";

    private DndUtil() {
    }

    public static <T extends Component> void updateDragSourceActivation(DragSource<T> dragSource) {
        Command & Serializable command = (Command & Serializable)() -> dragSource.getDraggableElement().executeJs("window.Vaadin.Flow.dndConnector.updateDragSource($0)", new Serializable[]{dragSource.getDraggableElement()});
        DndUtil.runOnAttachBeforeResponse(dragSource.getDragSourceComponent(), command);
    }

    public static <T extends Component> void updateDropTargetActivation(DropTarget<T> dropTarget) {
        Command & Serializable command = (Command & Serializable)() -> dropTarget.getElement().executeJs("window.Vaadin.Flow.dndConnector.updateDropTarget($0)", new Serializable[]{dropTarget.getElement()});
        DndUtil.runOnAttachBeforeResponse(dropTarget.getDropTargetComponent(), command);
        if (ComponentUtil.getData(dropTarget.getDropTargetComponent(), (String)DETACH_LISTENER_FOR_DROP_TARGET) == null) {
            Registration detachRegistration = dropTarget.getElement().addDetachListener((ElementDetachListener & Serializable)event -> DndUtil.runOnAttachBeforeResponse(dropTarget.getDropTargetComponent(), command));
            ComponentUtil.setData(dropTarget.getDropTargetComponent(), (String)DETACH_LISTENER_FOR_DROP_TARGET, (Object)detachRegistration);
        }
    }

    private static void runOnAttachBeforeResponse(Component component, Command command) {
        component.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(component, (SerializableConsumer & Serializable)context -> command.execute()));
    }

    public static void reportUsage() {
        UsageStatistics.markAsUsed((String)"flow/generic-dnd", null);
    }
}

