/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.SpringBridge;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.auth.AnnotatedViewAccessChecker;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.hilla.EndpointRegistry;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cglib.proxy.Proxy;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringIntegration {
    public static String getPropertyValue(VaadinServletContext context, String property) {
        WebApplicationContext webAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getContext());
        if (webAppContext == null) {
            SpringIntegration.getLogger().error("No web application context available");
            return null;
        }
        Environment env = webAppContext.getEnvironment();
        return env.getProperty(property, (String)null);
    }

    public static Class<?> getApplicationClass(VaadinServletContext context) {
        WebApplicationContext webAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getContext());
        if (webAppContext == null) {
            SpringIntegration.getLogger().error("No web application context available");
            return null;
        }
        Map beans = webAppContext.getBeansWithAnnotation(SpringBootApplication.class);
        Class<?> appClass = beans.values().iterator().next().getClass();
        if (Proxy.isProxyClass(appClass)) {
            appClass = appClass.getSuperclass();
        }
        while (SpringIntegration.isCglibProxy(appClass)) {
            appClass = appClass.getSuperclass();
        }
        return appClass;
    }

    private static boolean isCglibProxy(Class<?> appClass) {
        return appClass.getName().contains("$$SpringCGLIB$$");
    }

    public static Boolean isViewSecurityEnabled(VaadinServletContext context) {
        WebApplicationContext webAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getContext());
        if (webAppContext == null) {
            return false;
        }
        String[] naviAccessControl = webAppContext.getBeanNamesForType(NavigationAccessControl.class);
        if (naviAccessControl.length != 1) {
            return false;
        }
        NavigationAccessControl accessControl = (NavigationAccessControl)webAppContext.getBean(naviAccessControl[0]);
        return accessControl.hasAccessChecker(AnnotatedViewAccessChecker.class);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SpringIntegration.class);
    }

    public static List<SpringBridge.ServiceMethodInfo> getEndpoints(VaadinServletContext context) {
        WebApplicationContext webAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getContext());
        if (webAppContext == null) {
            return Collections.emptyList();
        }
        EndpointRegistry endpointRegistry = (EndpointRegistry)webAppContext.getBean(EndpointRegistry.class);
        Map vaadinEndpoints = endpointRegistry.getEndpoints();
        return SpringIntegration.getEndpointInfos(vaadinEndpoints);
    }

    public static List<SpringBridge.ServiceMethodInfo> getFlowUIServices(VaadinServletContext context) {
        WebApplicationContext webAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getContext());
        if (webAppContext == null) {
            return Collections.emptyList();
        }
        Collection springServices = webAppContext.getBeansWithAnnotation(Service.class).values();
        Stream<Class> serviceClassCandidates = springServices.stream().map(inst -> Proxy.isProxyClass(inst.getClass()) || SpringIntegration.isCglibProxy(inst.getClass()) ? inst.getClass().getSuperclass() : inst.getClass());
        serviceClassCandidates = serviceClassCandidates.filter(cls -> !cls.getPackage().getName().startsWith("com.vaadin"));
        Stream serviceMethods = serviceClassCandidates.flatMap(cls -> Arrays.stream(cls.getMethods()).filter(m -> !SpringIntegration.isObjectMethod(m)).map(method -> new SpringBridge.ServiceMethodInfo((Class<?>)cls, (Method)method)));
        return serviceMethods.toList();
    }

    private static boolean isObjectMethod(Method m) {
        return m.getDeclaringClass() == Object.class;
    }

    private static List<SpringBridge.ServiceMethodInfo> getEndpointInfos(Map<String, EndpointRegistry.VaadinEndpointData> vaadinEndpoints) {
        ArrayList<SpringBridge.ServiceMethodInfo> endpointInfos = new ArrayList<SpringBridge.ServiceMethodInfo>();
        for (EndpointRegistry.VaadinEndpointData endpoint : vaadinEndpoints.values()) {
            if (SpringIntegration.isInternalEndpoint(endpoint)) continue;
            Class<?> endpointClass = endpoint.getEndpointObject().getClass();
            Map methods = endpoint.getMethods();
            for (Method method : methods.values()) {
                endpointInfos.add(new SpringBridge.ServiceMethodInfo(endpointClass, method));
            }
        }
        return endpointInfos;
    }

    private static boolean isInternalEndpoint(EndpointRegistry.VaadinEndpointData endpointData) {
        String name = endpointData.getEndpointObject().getClass().getName();
        return name.startsWith("com.vaadin");
    }
}

