/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.parse.AbstractPerforceTemplate;
import com.tek42.perforce.parse.WorkspaceBuilder;
import java.util.List;

public class Workspaces
extends AbstractPerforceTemplate {
    public Workspaces(Depot depot) {
        super(depot);
    }

    public Workspace getWorkspace(String name) throws PerforceException {
        WorkspaceBuilder builder = new WorkspaceBuilder();
        Workspace workspace = (Workspace)builder.build(this.getPerforceResponse(builder.getBuildCmd(name)));
        if (workspace == null) {
            throw new PerforceException("Failed to retrieve workspace: " + name);
        }
        return workspace;
    }

    public List<String> getWorkspaceList() throws PerforceException {
        return this.getWorkspaceList(null);
    }

    public List<String> getWorkspaceList(String nameFilter) throws PerforceException {
        String[] cmd = nameFilter != null ? new String[]{"p4", "clients", "-e", nameFilter} : new String[]{"p4", "clients"};
        StringBuilder response = this.getPerforceResponse(cmd);
        List<String> clients = this.parseList(response, 1);
        return clients;
    }

    public void saveWorkspace(Workspace workspace) throws PerforceException {
        WorkspaceBuilder builder = new WorkspaceBuilder();
        this.saveToPerforce(workspace, builder);
    }

    public void syncToHead(String path) throws PerforceException {
        this.syncToHead(path, false);
    }

    public void syncToHead(String path, boolean forceSync) throws PerforceException {
        if (!path.endsWith("#head")) {
            path = path + "#head";
        }
        this.syncTo(path, forceSync);
    }

    public void syncTo(String path, boolean forceSync) throws PerforceException {
        if (forceSync) {
            this.getPerforceResponse(new String[]{"p4", "sync", "-f", path}, true);
        } else {
            this.getPerforceResponse(new String[]{"p4", "sync", path}, true);
        }
    }
}

