/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.parse.AbstractPerforceTemplate;
import com.tek42.perforce.parse.ChangelistBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class Changes
extends AbstractPerforceTemplate {
    public Changes(Depot depot) {
        super(depot);
    }

    public Changelist getChangelist(int number) throws PerforceException {
        ChangelistBuilder builder = new ChangelistBuilder();
        Changelist change = builder.build(this.getPerforceResponse(builder.getBuildCmd(Integer.toString(number))));
        if (change == null) {
            throw new PerforceException("Failed to retrieve changelist " + number);
        }
        return change;
    }

    public List<Changelist> getChangelists(String path, int lastChange, int limit) throws PerforceException {
        path = this.normalizePath(path);
        if (lastChange > 0) {
            path = path + "@" + lastChange;
        }
        String[] cmd = limit > 0 ? new String[]{"p4", "changes", "-m", Integer.toString(limit), "-s", "submitted", path} : new String[]{"p4", "changes", path};
        StringBuilder response = this.getPerforceResponse(cmd);
        List<String> ids = this.parseList(response, 1);
        ArrayList<Changelist> changes = new ArrayList<Changelist>();
        try {
            for (String id : ids) {
                changes.add(this.getChangelist(new Integer(id)));
            }
        }
        catch (NumberFormatException e) {
            throw new PerforceException("Unable to parse output for change numbers.  Output: " + response.toString(), e);
        }
        return changes;
    }

    public List<Integer> getChangeNumbers(String path, int start, int limit) throws PerforceException {
        path = this.normalizePath(path);
        if (start > 0) {
            path = path + "@" + start;
        }
        String[] cmd = limit > 0 ? new String[]{"p4", "changes", "-m", Integer.toString(limit), "-s", "submitted", path} : new String[]{"p4", "changes", path};
        StringBuilder response = this.getPerforceResponse(cmd);
        List<String> ids = this.parseList(response, 1);
        ArrayList<Integer> numbers = new ArrayList<Integer>(ids.size());
        try {
            for (String id : ids) {
                numbers.add(new Integer(id));
            }
        }
        catch (NumberFormatException e) {
            throw new PerforceException("Unable to parse output for change numbers.  Output: " + response.toString(), e);
        }
        return numbers;
    }

    public List<Integer> getChangeNumbersFrom(String depot, int fromRevision) throws PerforceException {
        String path = this.normalizePath(depot);
        if (fromRevision > 0) {
            path = path + "@" + fromRevision + ",@now";
        }
        String[] cmd = new String[]{"p4", "changes", "-s", "submitted", path};
        StringBuilder response = this.getPerforceResponse(cmd);
        List<String> ids = this.parseList(response, 1);
        ArrayList<Integer> numbers = new ArrayList<Integer>(ids.size());
        try {
            for (String id : ids) {
                numbers.add(new Integer(id));
            }
        }
        catch (NumberFormatException e) {
            throw new PerforceException("Unable to parse output for change numbers.  Output: " + response.toString(), e);
        }
        return numbers;
    }

    public List<Integer> getChangeNumbersTo(String path, int untilChange) throws PerforceException {
        return this.getChangeNumbersTo(null, path, untilChange);
    }

    public List<Integer> getChangeNumbersTo(String workspace, String path, int untilChange) throws PerforceException {
        String DELIM = " ";
        int MAX_PATHS_SUPPORTED_PER_COMMAND = 1;
        StringTokenizer allPaths = new StringTokenizer(path, DELIM);
        ArrayList<String> supportedPaths = new ArrayList<String>();
        StringBuilder currentPaths = new StringBuilder("");
        int numberOfPathsInCurrentPaths = 0;
        while (true) {
            if (!allPaths.hasMoreTokens()) {
                if (currentPaths.length() <= 0) break;
                supportedPaths.add(currentPaths.toString().trim());
                break;
            }
            String nextPath = allPaths.nextToken();
            currentPaths.append(nextPath).append(" ");
            if (++numberOfPathsInCurrentPaths != MAX_PATHS_SUPPORTED_PER_COMMAND) continue;
            supportedPaths.add(currentPaths.toString().trim());
            currentPaths.setLength(0);
            numberOfPathsInCurrentPaths = 0;
        }
        HashSet<Integer> uniqueIds = new HashSet<Integer>();
        for (String pathToUse : supportedPaths) {
            List<Integer> ids = this.getChangeNumbersToForSinglePath(workspace, pathToUse, untilChange);
            uniqueIds.addAll(ids);
        }
        ArrayList<Integer> sortedIds = new ArrayList<Integer>(uniqueIds);
        Collections.sort(sortedIds, Collections.reverseOrder());
        return sortedIds;
    }

    private List<Integer> getChangeNumbersToForSinglePath(String workspace, String path, int untilChange) throws PerforceException {
        path = this.normalizePath(path);
        ArrayList<String> cmdList = new ArrayList<String>();
        this.addCommand(cmdList, "p4", "changes", "-m", "25");
        this.addCommandWorkspace(cmdList, workspace);
        this.addCommand(cmdList, path);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        block2: while (true) {
            StringBuilder response;
            try {
                response = this.getPerforceResponse(cmdList.toArray(new String[cmdList.size()]));
            }
            catch (PerforceException e) {
                if (e.getMessage().startsWith("No output for")) break;
                throw e;
            }
            List<String> temp = this.parseList(response, 1);
            if (temp.isEmpty()) break;
            for (String num : temp) {
                if (new Integer(num) < untilChange) break block2;
                ids.add(new Integer(num));
            }
            String lastChange = temp.get(temp.size() - 1);
            int next = new Integer(lastChange) - 1;
            cmdList.clear();
            this.addCommand(cmdList, "p4", "changes", "-m", "25");
            this.addCommandWorkspace(cmdList, workspace);
            this.addCommand(cmdList, path + "@" + next);
        }
        return ids;
    }

    private void addCommandWorkspace(List<String> cmdList, String workspace) {
        if (workspace != null) {
            this.addCommand(cmdList, "-c", workspace);
        }
    }

    private String normalizePath(String path) {
        if (path == null || path.equals("")) {
            path = "//...";
        }
        return path;
    }

    private void addCommand(List<String> list, String ... args) {
        list.addAll(Arrays.asList(args));
    }

    public List<Changelist> getChangelistsFromNumbers(List<Integer> numbers) throws PerforceException {
        ArrayList<Changelist> changes = new ArrayList<Changelist>();
        for (Integer id : numbers) {
            changes.add(this.getChangelist(id));
        }
        return changes;
    }
}

