/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce;

import com.perforce.api.Env;
import com.tek42.perforce.parse.Changes;
import com.tek42.perforce.parse.Labels;
import com.tek42.perforce.parse.Status;
import com.tek42.perforce.parse.Users;
import com.tek42.perforce.parse.Workspaces;
import com.tek42.perforce.process.DefaultExecutorFactory;
import com.tek42.perforce.process.Executor;
import com.tek42.perforce.process.ExecutorFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Depot {
    private static Depot depot;
    private final Logger logger = Logger.getLogger(Depot.class);
    private final HashMap<String, String> settings = new HashMap();
    private String pathSep;
    private String fileSep;
    private boolean validEnvp;
    private String p4exe;
    private long threshold;
    private String p4Ticket;
    ExecutorFactory execFactory;
    private Changes changes;
    private Workspaces workspaces;
    private Users users;
    private Labels labels;
    private Status status;

    public static Depot getInstance() {
        if (depot == null) {
            depot = new Depot();
        }
        return depot;
    }

    public Depot() {
        this(new DefaultExecutorFactory(), Collections.emptyMap());
    }

    public Depot(Map<String, String> extraVariables) {
        this(new DefaultExecutorFactory(), extraVariables);
    }

    public Depot(ExecutorFactory factory, Map<String, String> extraVariables) {
        this.settings.putAll(System.getenv());
        this.settings.put("CLASSPATH", "/usr/share/java/p4.jar");
        this.setServerTimeout(10000L);
        String os = System.getProperty("os.name");
        if (os == null) {
            this.logger.warn((Object)"Found that the system property 'os.name' was null whilst configuring Perforce environment");
        } else if (os.startsWith("Windows")) {
            this.settings.put("PATHEXT", ".COM;.EXE;.BAT;.CMD");
            String windir = System.getProperty("com.ms.windir");
            if (windir != null) {
                this.appendPath(windir.substring(0, 1) + "\\Program Files\\Perforce");
                this.setSystemDrive(windir.substring(0, 1));
                this.setSystemRoot(windir);
            }
        }
        this.settings.putAll(extraVariables);
        this.execFactory = factory;
        this.execFactory.setEnv(this.settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorFactory getExecFactory() {
        HashMap<String, String> hashMap = this.settings;
        synchronized (hashMap) {
            if (!this.validEnvp) {
                this.execFactory.setEnv(this.settings);
                this.validEnvp = true;
            }
        }
        return this.execFactory;
    }

    public void setExecRunningDirectory(File runningDirectory) {
        if (this.execFactory != null) {
            this.execFactory.setRunningDirectory(runningDirectory);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Env getPerforceEnv() {
        Env env = new Env();
        env.setClient(this.getClient());
        env.setExecutable(this.getExecutable());
        env.setPassword(this.getPassword());
        env.setUser(this.getUser());
        env.setPort(this.getPort());
        env.setSystemDrive(this.getSystemDrive());
        env.setSystemRoot(this.getSystemRoot());
        return env;
    }

    public HashMap<String, String> getSettings() {
        return this.settings;
    }

    public Changes getChanges() {
        if (this.changes == null) {
            this.changes = new Changes(this);
        }
        return this.changes;
    }

    public Workspaces getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new Workspaces(this);
        }
        return this.workspaces;
    }

    public Users getUsers() {
        if (this.users == null) {
            this.users = new Users(this);
        }
        return this.users;
    }

    public Labels getLabels() {
        if (this.labels == null) {
            this.labels = new Labels(this);
        }
        return this.labels;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status(this);
        }
        return this.status;
    }

    public String info() throws Exception {
        String line;
        Executor p4 = this.getExecFactory().newExecutor();
        String[] cmd = new String[]{"p4", "info"};
        p4.exec(this.getExecutable(), cmd);
        StringBuilder sb = new StringBuilder();
        while ((line = p4.getReader().readLine()) != null) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    public String getProperty(String key) {
        return this.settings.get(key);
    }

    public String getProperty(String key, String def) {
        String value = this.getProperty(key);
        if (value == null || value.equals("")) {
            return def;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(String user) {
        if (null == user) {
            return;
        }
        HashMap<String, String> hashMap = this.settings;
        synchronized (hashMap) {
            this.settings.put("P4USER", user);
            this.validEnvp = false;
        }
    }

    public String getUser() {
        return this.settings.get("P4USER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClient(String client) {
        if (null == client) {
            return;
        }
        HashMap<String, String> hashMap = this.settings;
        synchronized (hashMap) {
            this.settings.put("P4CLIENT", client);
            this.validEnvp = false;
        }
    }

    public String getClient() {
        return this.settings.get("P4CLIENT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(String port) {
        if (null == port) {
            return;
        }
        HashMap<String, String> hashMap = this.settings;
        synchronized (hashMap) {
            this.settings.put("P4PORT", port);
            this.validEnvp = false;
        }
    }

    public String getPort() {
        return this.settings.get("P4PORT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        if (null == password) {
            return;
        }
        HashMap<String, String> hashMap = this.settings;
        synchronized (hashMap) {
            this.settings.put("P4PASSWD", password);
            this.validEnvp = false;
        }
    }

    public String getPassword() {
        return this.settings.get("P4PASSWD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) {
        if (null == path) {
            return;
        }
        HashMap<String, String> hashMap = this.settings;
        synchronized (hashMap) {
            this.settings.put("PATH", path);
            this.validEnvp = false;
        }
    }

    public void appendPath(String path) {
        if (null == path) {
            return;
        }
        String origPath = this.getProperty("PATH");
        if (null == this.pathSep || null == origPath) {
            this.setPath(path);
            return;
        }
        StringTokenizer st = new StringTokenizer(origPath, this.pathSep);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals(path)) {
                return;
            }
            sb.append(tok);
            sb.append(this.pathSep);
        }
        sb.append(path);
        this.setPath(path);
    }

    public String getPath() {
        return this.settings.get("PATH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemDrive(String drive) {
        if (null == drive) {
            return;
        }
        HashMap<String, String> hashMap = this.settings;
        synchronized (hashMap) {
            this.settings.put("SystemDrive", drive);
            this.validEnvp = false;
        }
    }

    public String getSystemDrive() {
        return this.settings.get("SystemDrive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemRoot(String root) {
        if (null == root) {
            return;
        }
        HashMap<String, String> hashMap = this.settings;
        synchronized (hashMap) {
            this.settings.put("SystemRoot", root);
            this.validEnvp = false;
        }
    }

    public String getSystemRoot() {
        return this.settings.get("SystemRoot");
    }

    public void setExecutable(String exe) {
        int pos;
        if (null == exe) {
            return;
        }
        this.p4exe = exe;
        if (null == this.fileSep) {
            this.fileSep = System.getProperties().getProperty("file.separator", "\\");
        }
        if (-1 == (pos = exe.lastIndexOf(this.fileSep))) {
            return;
        }
        if (null == this.pathSep) {
            this.pathSep = System.getProperties().getProperty("path.separator", ";");
        }
        this.appendPath(exe.substring(0, pos));
        this.validEnvp = false;
    }

    public String getExecutable() {
        return this.p4exe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAll(Settings newSettings) {
        HashMap<String, String> hashMap = this.settings;
        synchronized (hashMap) {
            this.setClient(newSettings.getClient());
            this.setExecutable(newSettings.getExecutable());
            this.setPassword(newSettings.getPassword());
            this.setPort(newSettings.getPort());
            this.setUser(newSettings.getUser());
        }
    }

    public void setServerTimeout(long threshold) {
        this.threshold = threshold;
    }

    public long getServerTimeout() {
        return this.threshold;
    }

    public String getP4Ticket() {
        return this.p4Ticket;
    }

    public void setP4Ticket(String ticket) {
        this.p4Ticket = ticket;
    }

    public static class Settings {
        private String executable;
        private String client;
        private String port;
        private String user;
        private String password;

        public void setExecutable(String executable) {
            this.executable = executable;
        }

        public String getExecutable() {
            return this.executable;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public String getClient() {
            return this.client;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getPort() {
            return this.port;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getUser() {
            return this.user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

