/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.EventLog;
import com.perforce.api.P4JNI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Date;
import org.apache.log4j.Logger;

public class P4Process {
    private static P4Process base = null;
    private P4JNI jni_proc = null;
    private boolean using_native = false;
    private Env environ = null;
    private Runtime rt = Runtime.getRuntime();
    private Process p;
    private BufferedReader in;
    private BufferedReader err;
    private Writer out;
    private int exit_code = 0;
    private EventLog log;
    private String P4_ERROR = null;
    private String[] new_cmd;
    private long threshold = 10000L;
    private boolean raw = false;
    private final Logger logger = Logger.getLogger(P4Process.class);

    public P4Process() {
        this(null);
    }

    public P4Process(Env e) {
        if (null == this.rt) {
            this.rt = Runtime.getRuntime();
        }
        if (null == e) {
            if (null == base) {
                base = this;
                this.environ = new Env();
            } else {
                this.environ = new Env(base.getEnv());
            }
        } else {
            this.environ = e;
        }
        if (null != this.environ) {
            this.threshold = this.environ.getServerTimeout();
        }
    }

    public void setEnv(Env e) {
        this.environ = e;
        if (null != this.environ) {
            this.threshold = this.environ.getServerTimeout();
        }
    }

    public Env getEnv() {
        return this.environ;
    }

    public static P4Process getBase() {
        if (null != base) {
            return base;
        }
        return new P4Process();
    }

    public static void setBase(P4Process b) {
        if (null != b) {
            base = b;
        }
    }

    public Writer getWriter() {
        return this.out;
    }

    public int getExitCode() {
        return this.exit_code;
    }

    public void setRawMode(boolean raw) {
        this.raw = raw;
    }

    public boolean getRawMode() {
        return this.raw;
    }

    public synchronized void exec(String[] cmd) throws IOException {
        String[] pre_cmds = new String[12];
        int i = 0;
        pre_cmds[i++] = cmd[0];
        pre_cmds[i++] = "-s";
        if (this.getEnv().getPort() != null && !this.getEnv().getPort().trim().equals("")) {
            pre_cmds[i++] = "-p";
            pre_cmds[i++] = this.getEnv().getPort();
        }
        if (this.getEnv().getUser() != null && !this.getEnv().getUser().trim().equals("")) {
            pre_cmds[i++] = "-u";
            pre_cmds[i++] = this.getEnv().getUser();
        }
        if (this.getEnv().getClient() != null && !this.getEnv().getClient().trim().equals("")) {
            pre_cmds[i++] = "-c";
            pre_cmds[i++] = this.getEnv().getClient();
        }
        if (this.getEnv().getPassword() != null && !this.getEnv().getPassword().trim().equals("")) {
            pre_cmds[i++] = "-P";
            pre_cmds[i++] = this.getEnv().getPassword();
        }
        if (cmd[1].equals("-x")) {
            pre_cmds[i++] = "-x";
            pre_cmds[i++] = cmd[2];
        }
        this.new_cmd = new String[i + cmd.length - 1];
        for (int j = 0; j < i + cmd.length - 1; ++j) {
            this.new_cmd[j] = j < i ? pre_cmds[j] : cmd[j - i + 1];
        }
        Debug.verbose("P4Process.exec: ", this.new_cmd);
        if (this.logger.isInfoEnabled()) {
            StringBuffer logString = new StringBuffer();
            for (String cm : this.new_cmd) {
                logString.append(cm).append(" ");
            }
            this.logger.info((Object)("Executing Perforce Command: " + logString));
        }
        if (P4JNI.isValid()) {
            this.native_exec(this.new_cmd);
            this.using_native = true;
        } else {
            this.pure_exec(this.new_cmd);
            this.using_native = false;
        }
    }

    private synchronized void native_exec(String[] cmd) throws IOException {
        this.jni_proc = new P4JNI();
        this.jni_proc.runCommand(this.jni_proc, cmd, this.environ);
        this.err = this.in = this.jni_proc.getReader();
        this.out = this.jni_proc.getWriter();
    }

    private synchronized void pure_exec(String[] cmd) throws IOException {
        if (null != this.environ.getExecutable()) {
            cmd[0] = this.environ.getExecutable();
        }
        this.p = this.rt.exec(cmd, this.environ.getEnvp());
        InputStream is = this.p.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        this.in = new BufferedReader(isr);
        InputStream es = this.p.getErrorStream();
        InputStreamReader esr = new InputStreamReader(es);
        this.err = new BufferedReader(esr);
        OutputStream os = this.p.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os);
        this.out = new FilterWriter(new BufferedWriter(osw)){

            @Override
            public void write(String str) throws IOException {
                super.write(str);
                System.out.print("P4DebugOutput: " + str);
            }
        };
    }

    public synchronized void setEventLog(EventLog log) {
        this.log = log;
    }

    private void log(PrintStream out, String event) {
        if (null == this.log) {
            out.println(event);
            out.flush();
        } else {
            this.log.log(event);
        }
    }

    public synchronized void print(String line) throws IOException {
        this.out.write(line);
    }

    public synchronized void println(String line) throws IOException {
        this.out.write(line + "\n");
    }

    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    public synchronized void outClose() throws IOException {
        this.out.flush();
        this.out.close();
    }

    public synchronized String readLine() {
        if (this.using_native && null != this.jni_proc && this.jni_proc.isPiped()) {
            return this.native_readLine();
        }
        return this.pure_readLine();
    }

    private synchronized String native_readLine() {
        try {
            return this.in.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private synchronized String pure_readLine() {
        long timeout = new Date().getTime() + this.threshold;
        if (null == this.p || null == this.in || null == this.err) {
            return null;
        }
        try {
            while (true) {
                if (null == this.p || null == this.in || null == this.err) {
                    Debug.error("P4Process.readLine(): Something went null");
                    return null;
                }
                long current = new Date().getTime();
                if (current >= timeout) {
                    Debug.error("P4Process.readLine(): Timeout");
                    for (int i = 0; i < this.new_cmd.length; ++i) {
                        if (!this.new_cmd[i].equals("-i")) continue;
                        return "";
                    }
                    return null;
                }
                try {
                    String line;
                    while (this.err.ready()) {
                        line = this.err.readLine();
                        if (null == line) continue;
                        this.addP4Error(line + "\n");
                    }
                    if (this.in.ready()) {
                        line = this.in.readLine();
                        Debug.verbose("From P4:" + line);
                        if (line.startsWith("error")) {
                            if (!line.trim().equals("") && -1 == line.indexOf("up-to-date") && -1 == line.indexOf("no file(s) to resolve")) {
                                this.addP4Error(line);
                            }
                        } else if (!line.startsWith("warning") && !line.startsWith("text") && !line.startsWith("info") && line.startsWith("exit")) {
                            int exit_code = new Integer(line.substring(line.indexOf(" ") + 1, line.length()));
                            if (0 == exit_code) {
                                Debug.verbose("P4 Exec Complete.");
                            } else {
                                Debug.error("P4 exited with an Error!");
                            }
                            return null;
                        }
                        if (!this.raw) {
                            line = line.substring(line.indexOf(":") + 1).trim();
                        }
                        return line;
                    }
                }
                catch (NullPointerException ne) {
                    // empty catch block
                }
                try {
                    this.exit_code = this.p.exitValue();
                    return null;
                }
                catch (IllegalThreadStateException ie) {
                    Debug.verbose("P4Process: Thread is not done yet.");
                    try {
                        Debug.verbose("P4Process: Sleeping...");
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie2) {}
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            return null;
        }
    }

    public synchronized int close(PrintStream out) throws IOException {
        if (this.using_native && null != this.jni_proc && this.jni_proc.isPiped()) {
            this.native_close(out);
        } else {
            this.pure_close(out);
        }
        if (null != this.P4_ERROR) {
            throw new IOException(this.P4_ERROR);
        }
        return this.exit_code;
    }

    private synchronized void native_close(PrintStream out) {
        try {
            this.in.close();
            out.flush();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void pure_close(PrintStream out) {
        for (int i = 0; i < 30; ++i) {
            try {
                this.in.close();
                this.err.close();
                out.flush();
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                this.exit_code = this.p.waitFor();
                this.p.destroy();
                break;
            }
            catch (InterruptedException ie) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public int close() throws IOException {
        return this.close(System.err);
    }

    public void setServerTimeout(long threshold) {
        this.threshold = threshold;
    }

    public long getServerTimeout() {
        return this.threshold;
    }

    public String toString() {
        return this.environ.toString();
    }

    private void addP4Error(String message) {
        this.P4_ERROR = null == this.P4_ERROR ? message : this.P4_ERROR + message;
    }
}

