/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Change;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.HashDecay;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import com.perforce.api.SourceControlObject;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public final class FileEntry
extends SourceControlObject {
    private String depot_path = null;
    private String client_path = null;
    private String description = "";
    private String owner = "";
    private FileEntry source = null;
    private int head_change = -1;
    private int head_rev = 0;
    private String head_type = "unknown";
    private long head_time = 0L;
    private int have_rev = 0;
    private int other_cnt = 0;
    private String head_action = "";
    private Vector others;
    private static HashDecay fentries;
    private String file_content = "";
    private DateFormat fmt = DateFormat.getDateTimeInstance(3, 2);

    public FileEntry() {
        this((Env)null);
    }

    public FileEntry(Env env) {
        super(env);
        if (null == this.others) {
            this.others = new Vector();
        }
    }

    public FileEntry(Env env, String p) {
        this(env);
        if (p.startsWith("//")) {
            this.depot_path = p;
        } else {
            this.client_path = p;
        }
    }

    public FileEntry(String p) {
        this(null, p);
    }

    private static HashDecay setCache() {
        if (null == fentries) {
            fentries = new HashDecay(120000L);
            fentries.start();
        }
        return fentries;
    }

    @Override
    public HashDecay getCache() {
        return FileEntry.setCache();
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public String getDescription() {
        return this.description;
    }

    public void setOwner(String o) {
        this.owner = o;
        int pos = this.owner.indexOf(64);
        if (-1 != pos) {
            this.owner = this.owner.substring(0, pos);
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setSource(FileEntry fent) {
        this.source = fent;
    }

    public FileEntry getSource() {
        return this.source;
    }

    public void setHeadType(String type) {
        this.head_type = type;
    }

    public String getHeadType() {
        return this.head_type;
    }

    public void setHeadDate(String date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        ParsePosition pos = new ParsePosition(0);
        Date hDate = formatter.parse(date, pos);
        this.head_time = hDate.getTime() / 1000L;
    }

    public String getHeadDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        return formatter.format(new Date(this.head_time * 1000L));
    }

    public void setHeadTime(long time) {
        this.head_time = time;
    }

    public long getHeadTime() {
        return this.head_time;
    }

    public void setTimeFormat(String format) {
        if (null == format) {
            return;
        }
        this.fmt = new SimpleDateFormat(format);
    }

    public String getHeadTimeString() {
        Date d = new Date(this.head_time * 1000L);
        if (null == this.fmt) {
            this.fmt = DateFormat.getDateTimeInstance(3, 2);
            this.fmt.setTimeZone(TimeZone.getTimeZone("EST"));
        }
        return this.fmt.format(d);
    }

    public void setHeadAction(String action) {
        this.head_action = action;
    }

    public String getHeadAction() {
        return this.head_action;
    }

    public void setHeadChange(int change) {
        this.head_change = change;
    }

    public int getHeadChange() {
        return this.head_change;
    }

    public void setHeadRev(int rev) {
        this.head_rev = rev;
    }

    public int getHeadRev() {
        return this.head_rev;
    }

    public void setHaveRev(int rev) {
        this.have_rev = rev;
    }

    public int getHaveRev() {
        return this.have_rev;
    }

    public void setDepotPath(String p) {
        this.depot_path = p;
    }

    public String getDepotPath() {
        return this.depot_path;
    }

    public static String localizePath(String path) {
        return FileEntry.customizePath(path, '/', File.separatorChar);
    }

    public static String depotizePath(String path) {
        return FileEntry.customizePath(path, File.separatorChar, '/');
    }

    public static String customizePath(String str, char from_char, char to_char) {
        StringBuffer strbuf = new StringBuffer();
        int beg = 0;
        int end = 0;
        while (-1 != (end = str.indexOf(from_char, beg))) {
            strbuf.append(str.substring(beg, end));
            strbuf.append(to_char);
            beg = end + 1;
        }
        strbuf.append(str.substring(beg));
        return strbuf.toString();
    }

    public String resolve(boolean force) throws IOException {
        String l;
        StringBuffer sb = new StringBuffer();
        String[] rescmd = new String[]{"p4", "resolve", "-am", "fileRev"};
        rescmd[2] = force || -1 != this.getHeadType().indexOf("binary") || -1 != this.getHeadType().indexOf("link") ? "-at" : "-am";
        rescmd[3] = this.getDepotPath();
        P4Process p = new P4Process(this.getEnv());
        p.exec(rescmd);
        while (null != (l = p.readLine())) {
            if (null == sb) continue;
            sb.append(l);
            sb.append('\n');
        }
        p.close();
        return sb.toString();
    }

    public static String resolveAT(Env env, Enumeration en) throws IOException {
        String l;
        StringBuffer sb = new StringBuffer();
        String[] rescmd = new String[]{"p4", "-x", "-", "resolve", "-at"};
        P4Process p = new P4Process(env);
        p.exec(rescmd);
        while (en.hasMoreElements()) {
            FileEntry fent = (FileEntry)en.nextElement();
            p.println(fent.getDepotPath());
            Debug.notify("resolveAT(): " + fent.getDepotPath());
        }
        p.println("\u001a\n\u001a");
        p.flush();
        p.outClose();
        Debug.notify("FileEntry.resolveAT(): Reading more lines.");
        while (null != (l = p.readLine())) {
            if (null == sb) continue;
            sb.append(l);
            sb.append('\n');
        }
        p.close();
        return sb.toString();
    }

    public static String resolveAll(Env env, String flags, String path) throws IOException {
        String l;
        StringBuffer sb = new StringBuffer();
        String[] rescmd = new String[]{"p4", "resolve", flags, path};
        P4Process p = new P4Process(env);
        p.exec(rescmd);
        Debug.notify("FileEntry.resolveAll(): Reading more lines.");
        while (null != (l = p.readLine())) {
            if (null == sb) continue;
            sb.append(l);
            sb.append('\n');
        }
        p.close();
        return sb.toString();
    }

    public static String HTMLEncode(String str) {
        if (null == str) {
            return null;
        }
        StringBuffer strbuf = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char tmp = str.charAt(i);
            if ('<' == tmp) {
                strbuf.append("&lt;");
                continue;
            }
            if ('>' == tmp) {
                strbuf.append("&gt;");
                continue;
            }
            strbuf.append(tmp);
        }
        return strbuf.toString();
    }

    public String getName() {
        String path = this.getDepotPath();
        if (null == path) {
            path = this.getClientPath();
        }
        if (null == path) {
            return "";
        }
        int pos = path.lastIndexOf(47);
        if (-1 == pos) {
            return path;
        }
        return path.substring(pos + 1);
    }

    public void setClientPath(String p) {
        this.client_path = p;
    }

    public String getClientPath() {
        return this.client_path;
    }

    public static synchronized FileEntry getFile(String p) {
        FileEntry f = new FileEntry(p);
        f.sync();
        return f;
    }

    public static Vector getFiles(Env env, String path) {
        Vector v = null;
        String[] cmd = new String[]{"p4", "fstat", path + "%1"};
        if (null == path) {
            return null;
        }
        try {
            P4Process p = new P4Process(env);
            p.exec(cmd);
            v = FileEntry.parseFstat(null, p, true);
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
        return v;
    }

    public static Vector getFileLog(Env env, String path) {
        String[] cmd = new String[]{"p4", "filelog", path};
        FileEntry fent = null;
        FileEntry tmpent = null;
        Vector<FileEntry> v = new Vector<FileEntry>();
        if (null == path) {
            return v;
        }
        try {
            String l;
            P4Process p = new P4Process(env);
            p.setRawMode(true);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                int end;
                int beg;
                if ((l = l.trim()).startsWith("info2: ") && null != fent) {
                    tmpent = new FileEntry(env);
                    beg = 8;
                    end = l.indexOf(32, beg);
                    if (-1 == end) continue;
                    tmpent.setHeadAction(l.substring(beg, end));
                    beg = end;
                    end = l.indexOf("from ");
                    if (-1 == end) {
                        tmpent.setDepotPath(path);
                    } else {
                        beg = end + 5;
                        if (-1 == (end = l.indexOf(35, beg))) {
                            tmpent.setDepotPath(l.substring(beg));
                        } else {
                            tmpent.setDepotPath(l.substring(beg, end));
                        }
                    }
                    end = l.lastIndexOf(35);
                    if (-1 != end) {
                        beg = l.lastIndexOf(35, end - 1);
                        if (-1 != beg) {
                            tmpent.setHaveRev(Integer.parseInt(l.substring(beg + 1, end - 1)));
                        }
                        tmpent.setHeadRev(Integer.parseInt(l.substring(end + 1)));
                    }
                    fent.setSource(tmpent);
                    continue;
                }
                if (!l.startsWith("info1: ")) continue;
                if (null != fent) {
                    v.addElement(fent);
                }
                fent = new FileEntry(env);
                fent.setDepotPath(path);
                StringTokenizer st = new StringTokenizer(l.substring(8));
                fent.setHeadRev(Integer.parseInt(st.nextToken()));
                st.nextToken();
                fent.setHeadChange(Integer.parseInt(st.nextToken()));
                fent.setHeadAction(st.nextToken());
                st.nextToken();
                fent.setHeadDate(st.nextToken());
                st.nextToken();
                fent.setOwner(st.nextToken());
                String tmp = st.nextToken();
                fent.setHeadType(tmp.substring(1, tmp.length() - 1));
                end = l.lastIndexOf(39);
                if (1 >= end || -1 >= (beg = l.lastIndexOf(39, end - 1)) || end - beg - 1 <= 0) continue;
                fent.setDescription(l.substring(beg + 1, end - 1));
            }
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
        if (null != fent && null != fent.getDepotPath()) {
            v.addElement(fent);
        }
        return v;
    }

    public static FileEntry openForEdit(Env env, String path, boolean sync, boolean force, boolean lock, Change chng) throws Exception {
        if (sync) {
            FileEntry.syncWorkspace(env, path);
        }
        FileEntry fent = new FileEntry(env, path);
        fent.openForEdit(force, lock, chng);
        return fent;
    }

    public void openForEdit() throws Exception {
        this.openForEdit(true, false, null);
    }

    public void openForEdit(boolean force, boolean lock) throws Exception {
        this.openForEdit(force, lock, null);
    }

    public void openForEdit(boolean force, boolean lock, Change chng) throws Exception {
        String l;
        String[] cmd1;
        int i = 0;
        this.sync();
        if (force) {
            cmd1 = new String[4];
            cmd1[2] = "-f";
        } else {
            cmd1 = new String[3];
        }
        cmd1[0] = "p4";
        cmd1[1] = "sync";
        cmd1[cmd1.length - 1] = this.getDepotPath();
        String[] cmd2 = new String[null == chng ? 3 : 5];
        cmd2[i++] = "p4";
        cmd2[i++] = "edit";
        if (null != chng) {
            cmd2[i++] = "-c";
            cmd2[i++] = String.valueOf(chng.getNumber());
        }
        cmd2[i++] = this.getClientPath();
        P4Process p = new P4Process(this.getEnv());
        p.exec(cmd1);
        while (null != (l = p.readLine())) {
        }
        p.close();
        p = new P4Process(this.getEnv());
        p.exec(cmd2);
        while (null != (l = p.readLine())) {
        }
        p.close();
        if (lock) {
            this.obtainLock();
        }
    }

    public void obtainLock() throws Exception {
        String l;
        String[] cmd = new String[]{"p4", "lock", this.getDepotPath()};
        P4Process p = new P4Process(this.getEnv());
        p.exec(cmd);
        while (null != (l = p.readLine())) {
        }
        p.close();
    }

    public static FileEntry openForAdd(Env env, String path, Change chng) throws Exception {
        FileEntry fent = new FileEntry(env, path);
        fent.openForAdd(chng);
        return fent;
    }

    public void openForAdd() throws Exception {
        this.openForAdd(null);
    }

    public void openForAdd(Change chng) throws Exception {
        String l;
        int i = 0;
        String[] cmd = new String[null == chng ? 3 : 5];
        cmd[i++] = "p4";
        cmd[i++] = "add";
        if (null != chng) {
            cmd[i++] = "-c";
            cmd[i++] = String.valueOf(chng.getNumber());
        }
        cmd[i++] = this.getClientPath();
        if (null == this.getClientPath()) {
            throw new Exception("No Client Path");
        }
        P4Process p = new P4Process(this.getEnv());
        p.exec(cmd);
        while (null != (l = p.readLine())) {
        }
        p.close();
    }

    public static FileEntry checkIn(Env env, String path, String description) throws PerforceException {
        FileEntry fent = new FileEntry(env, path);
        Change chng = new Change(env);
        chng.setDescription(description);
        chng.addFile(fent);
        chng.submit();
        fent.sync();
        return fent;
    }

    public void reopen(String type, Change chng) throws PerforceException {
        int i = 0;
        P4Process p = null;
        if (null == this.getClientPath()) {
            try {
                this.sync();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (null == this.getClientPath()) {
                throw new PerforceException("No Client Path");
            }
        }
        if (null == type && null == chng) {
            return;
        }
        String[] cmd = new String[null == type || null == chng ? 5 : 7];
        cmd[i++] = "p4";
        cmd[i++] = "reopen";
        if (null != type) {
            cmd[i++] = "-t";
            cmd[i++] = type;
        }
        if (null != chng) {
            cmd[i++] = "-c";
            cmd[i++] = String.valueOf(chng.getNumber());
        }
        cmd[i++] = this.getClientPath();
        try {
            String l;
            p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (-1 == l.indexOf("not opened on this client") && -1 == l.indexOf("Invalid file type") && -1 == l.indexOf("unknown")) continue;
                throw new PerforceException(l);
            }
        }
        catch (Exception ex) {
            throw new PerforceException(ex.getMessage());
        }
        finally {
            if (null != p) {
                try {
                    p.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public boolean revert() {
        String[] cmd1 = new String[]{"p4", "revert", this.getDepotPath()};
        String[] cmd2 = new String[]{"p4", "sync", this.getDepotPath() + "#none"};
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd1);
            while (null != (l = p.readLine())) {
            }
            p.close();
            p = new P4Process(this.getEnv());
            p.exec(cmd2);
            while (null != (l = p.readLine())) {
            }
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
            return false;
        }
        return true;
    }

    public static Vector getOpened() {
        return FileEntry.getOpened(null, true, false, -1, null);
    }

    public static Vector getOpened(Env env, boolean stat) {
        return FileEntry.getOpened(env, stat, false, -1, null);
    }

    public static Vector getOpened(Env env, boolean stat, boolean all, int changelist, Vector files) {
        FileEntry fent;
        Enumeration en;
        Vector<FileEntry> v = new Vector<FileEntry>();
        int i = 0;
        int cnt = 2;
        if (all) {
            ++cnt;
        }
        if (0 <= changelist) {
            cnt += 2;
        }
        if (null != files) {
            cnt += files.size();
        }
        String[] cmd = new String[cnt];
        cmd[i++] = "p4";
        cmd[i++] = "opened";
        if (all) {
            cmd[i++] = "-a";
        }
        if (0 <= changelist) {
            cmd[i++] = "-c";
            String string = cmd[i++] = 0 == changelist ? "default" : String.valueOf(changelist);
        }
        if (null != files) {
            en = files.elements();
            while (en.hasMoreElements()) {
                cmd[i++] = (String)en.nextElement();
            }
        }
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                StringTokenizer st;
                String str;
                if (!l.startsWith("//") || null == (str = (st = new StringTokenizer(l, "#")).nextToken())) continue;
                fent = new FileEntry(env, str);
                str = st.nextToken("# \t");
                if (null == str) continue;
                fent.setHeadRev(Integer.valueOf(str));
                st.nextToken(" \t");
                str = st.nextToken();
                if (null == str) continue;
                fent.setHeadAction(str);
                str = st.nextToken();
                if (null == str) continue;
                if (str.equals("default")) {
                    fent.setHeadChange(-1);
                    st.nextToken();
                } else if (str.equals("change")) {
                    str = st.nextToken();
                    if (null == str) continue;
                    fent.setHeadChange(Integer.valueOf(str));
                }
                str = st.nextToken(" \t()");
                if (null == str) continue;
                fent.setHeadType(str);
                for (i = 0; i < v.size() && ((FileEntry)v.elementAt(i)).getHeadChange() <= fent.getHeadChange(); ++i) {
                }
                v.insertElementAt(fent, i);
            }
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
        if (stat) {
            en = v.elements();
            while (en.hasMoreElements()) {
                fent = (FileEntry)en.nextElement();
                fent.setEnv(env);
                fent.sync();
            }
        }
        return v;
    }

    @Override
    public void commit() {
    }

    public String syncMySpace(Env env, String path) throws IOException {
        return FileEntry.syncWorkspace(env, path);
    }

    public static Vector synchronizeWorkspace(Env env, String path) throws IOException {
        String[] cmd;
        if (null == path || path.trim().equals("")) {
            cmd = new String[2];
        } else {
            cmd = new String[3];
            cmd[2] = path;
        }
        cmd[0] = "p4";
        cmd[1] = "sync";
        Vector<FileEntry> v = new Vector<FileEntry>();
        FileEntry fent = null;
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                fent = null;
                if (!l.startsWith("//")) continue;
                int pos1 = 0;
                int pos2 = l.indexOf(35);
                if (-1 == pos2) continue;
                fent = new FileEntry(env, l.substring(pos1, pos2));
                pos1 = pos2 + 1;
                if (-1 == (pos2 = l.indexOf(32, pos1))) continue;
                try {
                    fent.setHeadRev(Integer.parseInt(l.substring(pos1, pos2)));
                }
                catch (Exception ex) {
                    fent = null;
                    continue;
                }
                pos1 = pos2 + 1;
                pos2 = l.indexOf("updating ");
                if (-1 != pos2 || -1 != (pos2 = l.indexOf("added as "))) {
                    fent.setClientPath(l.substring(pos2 + 9).trim());
                }
                if (null == fent) continue;
                v.addElement(fent);
                fent = null;
            }
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
            throw ex;
        }
        return v;
    }

    public static String syncWorkspace(Env env, String path) throws IOException {
        String[] cmd;
        if (null == path || path.trim().equals("")) {
            cmd = new String[3];
            cmd[2] = path;
        } else {
            cmd = new String[]{"p4", "sync"};
        }
        String str = "";
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                str = str + l + "\n";
            }
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
            throw ex;
        }
        return str;
    }

    public String getFileContents() {
        return this.getFileContents(this.getEnv(), this.getDepotPath());
    }

    public String getFileContents(Env env, String path) {
        StringBuffer ret = null;
        String[] cmd = new String[]{"p4", "print", path};
        try {
            String l;
            P4Process p = new P4Process(env);
            p.setRawMode(true);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (null == ret) {
                    ret = new StringBuffer();
                    continue;
                }
                if (!l.startsWith("text: ")) continue;
                ret.append(l.substring(6));
                if (l.endsWith("\n")) continue;
                ret.append('\n');
            }
            if (null == ret) {
                ret = new StringBuffer();
            }
            if (0 != p.close()) {
                throw new IOException("P4 exited with and error:" + p.getExitCode());
            }
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
        this.file_content = ret.toString();
        return this.file_content;
    }

    @Override
    public void sync() {
        String[] cmd = new String[]{"p4", "fstat", "path"};
        if (null != this.depot_path) {
            cmd[2] = this.depot_path;
        } else if (null != this.client_path) {
            cmd[2] = this.client_path;
        } else {
            return;
        }
        if (0 != this.head_rev) {
            cmd[2] = cmd[2] + "#" + this.head_rev;
        }
        try {
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            FileEntry.parseFstat(this, p, false);
            if (0 != p.close()) {
                throw new IOException("P4 exited with an error:" + p.getExitCode());
            }
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
    }

    private static Vector parseFstat(FileEntry fe, P4Process p, boolean igndel) {
        String l;
        Vector<FileEntry> v = new Vector<FileEntry>();
        boolean multiple = false;
        if (null == p) {
            return null;
        }
        FileEntry nfe = fe;
        if (null == nfe) {
            nfe = new FileEntry(p.getEnv());
        }
        while (null != (l = p.readLine())) {
            StringTokenizer tokes = new StringTokenizer(l, " ");
            String dataname = (String)(tokes.hasMoreElements() ? tokes.nextElement() : null);
            String datavalue = (String)(tokes.hasMoreElements() ? tokes.nextElement() : null);
            if (dataname.equals("clientFile")) {
                nfe.setClientPath(datavalue);
                continue;
            }
            if (dataname.equals("depotFile")) {
                if (multiple) {
                    nfe = new FileEntry(p.getEnv());
                }
                nfe.setDepotPath(datavalue);
                v.add(nfe);
                multiple = true;
                continue;
            }
            if (dataname.equals("headAction")) {
                nfe.setHeadAction(datavalue);
                continue;
            }
            if (dataname.equals("headChange")) {
                nfe.setHeadChange(new Integer(datavalue));
                continue;
            }
            if (dataname.equals("headRev")) {
                nfe.setHeadRev(new Integer(datavalue));
                continue;
            }
            if (dataname.equals("headType")) {
                nfe.setHeadType(datavalue);
                continue;
            }
            if (dataname.equals("headTime")) {
                nfe.setHeadTime(new Long(datavalue));
                continue;
            }
            if (dataname.equals("haveRev")) {
                nfe.setHaveRev(new Integer(datavalue));
                continue;
            }
            if (!dataname.equals("action") && !dataname.equals("change") && !dataname.equals("unresolved") && !dataname.equals("otherOpen") && !dataname.equals("otherLock") && !dataname.equals("ourLock")) continue;
        }
        return v;
    }

    public String toString() {
        return this.depot_path + "\n" + this.client_path + "\nothers: " + this.other_cnt;
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer("<file><have rev=\"");
        sb.append(this.getHaveRev());
        sb.append("\"/><head rev=\"");
        sb.append(this.getHeadRev());
        sb.append("\" change=\"");
        sb.append(this.getHeadChange());
        sb.append("\" type=\"");
        sb.append(this.getHeadType());
        sb.append("\" action=\"");
        sb.append(this.getHeadAction());
        sb.append("\" time=\"");
        sb.append(this.getHeadTimeString());
        sb.append("\"/>");
        sb.append("<path type=\"depot\">");
        sb.append(this.getDepotPath());
        sb.append("</path>");
        sb.append("<path type=\"client\">");
        sb.append(this.getClientPath());
        sb.append("</path>");
        if (null != this.getDescription()) {
            sb.append("<description>");
            sb.append(this.getDescription());
            sb.append("</description>");
        }
        sb.append("</file>");
        return sb.toString();
    }
}

