/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.CommitException;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.HashDecay;
import com.perforce.api.Mapping;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import com.perforce.api.Utils;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public final class Client
extends Mapping {
    private String root = "";
    private String options = "";
    private static final int DECAY_TIMEOUT = 86400000;
    private static HashDecay clients = null;
    private static long load_time = 0L;
    private static final Logger logger = Logger.getLogger(Client.class);

    public Client() {
        this.getCache();
    }

    public Client(String name) {
        this(null, name);
    }

    public Client(Env env, String name) {
        this();
        this.setEnv(env);
        this.setName(name);
    }

    private static synchronized HashDecay setCache() {
        if (null == clients) {
            clients = new HashDecay(86400000L);
            clients.start();
        }
        if (clients.isEmpty()) {
            load_time = 0L;
        }
        return clients;
    }

    @Override
    public HashDecay getCache() {
        return Client.setCache();
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getOptions() {
        return this.options;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Client getClient(Env env, String name) {
        if (null == name || name.trim().equals("")) {
            return null;
        }
        Client c = (Client)Client.setCache().get(name);
        if (null == c) {
            c = new Client(name);
        }
        if (null != env) {
            c.setEnv(env);
        }
        c.sync();
        HashDecay hashDecay = clients;
        synchronized (hashDecay) {
            clients.put((Object)name, c);
        }
        return c;
    }

    public static synchronized Client getClient(String name) {
        return Client.getClient(null, name);
    }

    public static Enumeration<Client> lookupClient(Env env, String prefix) throws PerforceException {
        Client.loadClients(env);
        return Client.lookupMappings(clients, prefix);
    }

    public static Enumeration<Client> lookupClient(String prefix) throws PerforceException {
        Client.loadClients(null);
        return Client.lookupMappings(clients, prefix);
    }

    public static Enumeration<Client> getClients() throws PerforceException {
        Client.loadClients(null);
        return clients.keys();
    }

    public static Enumeration<Client> getClients(Env env) throws PerforceException {
        return Utils.getEnumeration(Client.getClientIterator(env));
    }

    public static Iterator<Client> getClientIterator(Env env) throws PerforceException {
        Client.loadClients(env);
        Enumeration en = clients.elements();
        TreeSet ts = new TreeSet();
        while (en.hasMoreElements()) {
            ts.add(en.nextElement());
        }
        return ts.iterator();
    }

    public static void loadClients() throws PerforceException {
        Client.loadClients(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadClients(Env env) throws PerforceException {
        String[] cmd = new String[]{"p4", "clients"};
        Client.setCache();
        HashDecay hashDecay = clients;
        synchronized (hashDecay) {
            Date date = new Date();
            if ((double)clients.getDelay() * 0.5 > (double)(date.getTime() - load_time)) {
                return;
            }
            try {
                P4Process p = new P4Process(env);
                try {
                    String l;
                    p.exec(cmd);
                    while (null != (l = p.readLine())) {
                        if (!l.startsWith("Client")) continue;
                        try {
                            StringTokenizer st = new StringTokenizer(l.trim());
                            if (6 > st.countTokens()) continue;
                            st.nextToken();
                            String name = st.nextToken();
                            Client c = (Client)clients.get(name);
                            if (null != c) {
                                c.refreshUpdateTime();
                                continue;
                            }
                            c = new Client(name);
                            c.setEnv(env);
                            st.nextToken();
                            st.nextToken();
                            c.setRoot(st.nextToken());
                            if (null != st.nextToken("'")) {
                                c.setDescription(st.nextToken());
                            } else {
                                c.setDescription("");
                            }
                            clients.put((Object)c.getName(), c);
                        }
                        catch (NoSuchElementException ex) {}
                    }
                }
                finally {
                    p.close();
                }
                load_time = new Date().getTime();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new PerforceException(ex);
            }
        }
    }

    public void store() throws CommitException {
        this.commit();
    }

    @Override
    public void commit() throws CommitException {
        String[] cmd = new String[]{"p4", "client", "-i"};
        int cnt = 0;
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            p.println("Client: " + this.getName());
            p.println("Owner: " + this.getOwner());
            p.println("Root: " + this.getRoot());
            p.println("Description: " + this.getDescription());
            p.println("View:");
            p.println(this.getView());
            p.flush();
            p.outClose();
            while (null != (l = p.readLine())) {
                if (0 != cnt++) continue;
            }
            p.close();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new CommitException(ex.getMessage());
        }
    }

    @Override
    public void sync() {
        this.sync(this.getName());
    }

    @Override
    public void sync(String name) {
        if (!this.outOfSync(60000L)) {
            return;
        }
        String description = "";
        String[] cmd = new String[]{"p4", "client", "-o", "name"};
        cmd[3] = name;
        this.setName(name);
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (l.startsWith("#")) continue;
                if (l.startsWith("Client:")) {
                    this.setName(l.substring(8).trim());
                    continue;
                }
                if (l.startsWith("Owner:")) {
                    this.setOwner(l.substring(7).trim());
                    continue;
                }
                if (l.startsWith("Root:")) {
                    this.setRoot(l.substring(6).trim());
                    continue;
                }
                if (l.startsWith("Options:")) {
                    this.setOptions(l.substring(9).trim());
                    continue;
                }
                if (l.startsWith("Description:")) {
                    while (null != (l = p.readLine()) && l.startsWith("\t")) {
                        description = description + l + "\n";
                    }
                    this.setDescription(description);
                    continue;
                }
                if (!l.startsWith("View:")) continue;
                while (null != (l = p.readLine()) && (l.startsWith("\t") || l.startsWith(" ") || l.startsWith("//"))) {
                    this.addView(l);
                }
            }
            p.close();
            this.inSync();
        }
        catch (IOException ex) {
            logger.error((Object)ex);
            Debug.out(1, ex);
        }
        this.refreshUpdateTime();
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer("<client name=\"");
        sb.append(this.getName());
        sb.append("\" owner=\"");
        sb.append(this.getOwner());
        sb.append("\" root=\"");
        sb.append(this.getRoot());
        sb.append("\" options=\"");
        sb.append(this.getOptions());
        sb.append("\">");
        sb.append(super.toXML());
        sb.append("</client>");
        return sb.toString();
    }
}

