/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.PathWatchers;
import com.swoval.files.RegisterableWatchService;
import com.swoval.files.TypedPaths;
import com.swoval.files.WatchedDirectoriesByPath;
import com.swoval.files.WatchedDirectory;
import com.swoval.functional.Consumer;
import com.swoval.functional.Either;
import com.swoval.logging.Logger;
import com.swoval.logging.Loggers;
import com.swoval.runtime.ShutdownHooks;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class NioPathWatcherService
implements AutoCloseable {
    private final Thread loopThread;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private static final AtomicInteger threadId = new AtomicInteger(0);
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final RegisterableWatchService watchService;
    private final WatchedDirectoriesByPath watchedDirectoriesByPath = new WatchedDirectoriesByPath();
    private final int shutdownHookId;
    private final Logger logger;

    NioPathWatcherService(final Consumer<Either<PathWatchers.Overflow, PathWatchers.Event>> consumer, final RegisterableWatchService registerableWatchService, final Logger logger) throws InterruptedException {
        this.watchService = registerableWatchService;
        this.logger = logger;
        this.shutdownHookId = ShutdownHooks.addHook(1, new Runnable(){

            @Override
            public void run() {
                NioPathWatcherService.this.close();
            }
        });
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final String string = this.toString();
        this.loopThread = new Thread("NioPathWatcher-loop-thread-" + threadId.incrementAndGet()){

            @Override
            public void run() {
                countDownLatch.countDown();
                boolean bl = false;
                while (!(NioPathWatcherService.this.isStopped.get() || bl || Thread.currentThread().isInterrupted())) {
                    try {
                        WatchKey watchKey = registerableWatchService.take();
                        List<WatchEvent<?>> list = watchKey.pollEvents();
                        if (!watchKey.reset()) {
                            watchKey.cancel();
                        }
                        for (WatchEvent<?> watchEvent : list) {
                            Object object;
                            WatchEvent.Kind<?> kind = watchEvent.kind();
                            if (Loggers.shouldLog(logger, Loggers.Level.DEBUG)) {
                                logger.debug(string + " received event for path " + watchEvent.context() + " with kind " + kind);
                            }
                            if (StandardWatchEventKinds.OVERFLOW.equals(kind)) {
                                object = Either.left(new PathWatchers.Overflow((Path)watchKey.watchable()));
                                consumer.accept(object);
                                continue;
                            }
                            if (kind == null) continue;
                            object = kind.equals(StandardWatchEventKinds.ENTRY_DELETE) ? PathWatchers.Event.Kind.Delete : (kind.equals(StandardWatchEventKinds.ENTRY_CREATE) ? PathWatchers.Event.Kind.Create : PathWatchers.Event.Kind.Modify);
                            Path path = (Path)watchKey.watchable();
                            Path path2 = watchEvent.context() == null ? path : path.resolve((Path)watchEvent.context());
                            Either either = Either.right(new PathWatchers.Event(TypedPaths.get(path2, 8), (PathWatchers.Event.Kind)object));
                            consumer.accept(either);
                        }
                    }
                    catch (InterruptedException | ClosedWatchServiceException exception) {
                        bl = true;
                    }
                }
                NioPathWatcherService.this.shutdownLatch.countDown();
            }
        };
        this.loopThread.setDaemon(true);
        this.loopThread.start();
        countDownLatch.await(5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Either<IOException, WatchedDirectory> register(Path path) {
        Either<IOException, WatchedDirectory> either;
        block13: {
            if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                this.logger.debug(this + " registering " + path);
            }
            try {
                if (this.watchedDirectoriesByPath.lock()) {
                    try {
                        WatchedDirectory watchedDirectory = (WatchedDirectory)this.watchedDirectoriesByPath.get(path);
                        if (watchedDirectory == null) {
                            CachedWatchDirectory cachedWatchDirectory = new CachedWatchDirectory(path);
                            this.watchedDirectoriesByPath.put(path, cachedWatchDirectory);
                            if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                                this.logger.debug(this + " creating new watch key for " + path);
                            }
                            either = Either.right(cachedWatchDirectory);
                        } else {
                            if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                                this.logger.debug(this + " using existing watch key for " + path);
                            }
                            either = Either.right(watchedDirectory);
                        }
                        break block13;
                    }
                    finally {
                        this.watchedDirectoriesByPath.unlock();
                    }
                }
                either = Either.right(null);
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
                either = Either.left(new IOException(closedWatchServiceException));
            }
            catch (IOException iOException) {
                either = Either.left(iOException);
            }
        }
        if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
            this.logger.debug(this + " registration for " + path + " " + (either.isLeft() ? "failed (" + either + ")" : "succeeded"));
        }
        return either;
    }

    @Override
    public void close() {
        if (this.isStopped.compareAndSet(false, true)) {
            ShutdownHooks.removeHook(this.shutdownHookId);
            this.loopThread.interrupt();
            try {
                Iterator iterator = this.watchedDirectoriesByPath.values().iterator();
                while (iterator.hasNext()) {
                    ((WatchedDirectory)iterator.next()).close();
                }
                this.isShutdown.set(true);
                this.watchService.close();
                this.shutdownLatch.await(5L, TimeUnit.SECONDS);
                this.loopThread.join(5000L);
            }
            catch (IOException | InterruptedException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private final class CachedWatchDirectory
    implements WatchedDirectory {
        private final Path path;
        private final WatchKey key;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        CachedWatchDirectory(Path path) throws IOException {
            this.path = path;
            this.key = NioPathWatcherService.this.watchService.register(path, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }

        @Override
        public void close() {
            if (!NioPathWatcherService.this.isShutdown.get() && this.closed.compareAndSet(false, true)) {
                if (Loggers.shouldLog(NioPathWatcherService.this.logger, Loggers.Level.DEBUG)) {
                    NioPathWatcherService.this.logger.debug(this + " stopping watch");
                }
                NioPathWatcherService.this.watchedDirectoriesByPath.remove(this.path);
                this.key.reset();
                this.key.cancel();
            }
        }

        public String toString() {
            return "WatchedDirectory(" + this.path + ")";
        }
    }
}

