/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.DirectoryRegistry;
import com.swoval.files.DirectoryWatcher;
import com.swoval.files.Executor;
import com.swoval.files.NioDirectoryWatcher;
import com.swoval.files.Registerable;
import com.swoval.files.WatchedDirectory;
import com.swoval.functional.Consumer;
import com.swoval.functional.Either;
import com.swoval.functional.IO;
import com.swoval.runtime.ShutdownHooks;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class NioDirectoryWatcherImpl
extends NioDirectoryWatcher {
    private final Thread loopThread;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private static final AtomicInteger threadId = new AtomicInteger(0);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final Registerable watchService;

    NioDirectoryWatcherImpl(final Consumer<DirectoryWatcher.Event> consumer, final Registerable registerable, Executor executor, final Executor executor2, DirectoryRegistry directoryRegistry, DirectoryWatcher.Option ... optionArray) throws InterruptedException {
        super(new IO<Path, WatchedDirectory>(){
            final Map<Path, WatchedDirectory> watchedDirectoriesByPath = new HashMap<Path, WatchedDirectory>();

            @Override
            public Either<IOException, WatchedDirectory> apply(final Path path) {
                Either<IOException, WatchedDirectory> either;
                try {
                    WatchedDirectory watchedDirectory = this.watchedDirectoriesByPath.get(path);
                    if (watchedDirectory == null) {
                        WatchedDirectory watchedDirectory2 = new WatchedDirectory(){
                            private final WatchKey key;
                            private final AtomicBoolean closed;
                            {
                                this.key = registerable.register(path, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                                this.closed = new AtomicBoolean(false);
                            }

                            public boolean isValid() {
                                return true;
                            }

                            public void reset() {
                                if (!this.key.reset()) {
                                    this.key.cancel();
                                }
                            }

                            @Override
                            public void close() {
                                if (this.closed.compareAndSet(false, true)) {
                                    watchedDirectoriesByPath.remove(path);
                                    this.key.reset();
                                    this.key.cancel();
                                }
                            }
                        };
                        this.watchedDirectoriesByPath.put(path, watchedDirectory2);
                        either = Either.right(watchedDirectory2);
                    } else {
                        either = Either.right(watchedDirectory);
                    }
                }
                catch (ClosedWatchServiceException closedWatchServiceException) {
                    either = Either.left(new IOException(closedWatchServiceException));
                }
                catch (IOException iOException) {
                    either = Either.left(iOException);
                }
                return either;
            }
        }, executor, executor2, directoryRegistry, optionArray);
        this.watchService = registerable;
        ShutdownHooks.addHook((int)1, (Runnable)new Runnable(){

            @Override
            public void run() {
                NioDirectoryWatcherImpl.this.close();
            }
        });
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.loopThread = new Thread("NioDirectoryWatcher-loop-thread-" + threadId.incrementAndGet()){

            @Override
            public void run() {
                countDownLatch.countDown();
                boolean bl = false;
                while (!(NioDirectoryWatcherImpl.this.isStopped.get() || bl || Thread.currentThread().isInterrupted())) {
                    try {
                        final WatchKey watchKey = registerable.take();
                        boolean bl2 = false;
                        while (!bl2) {
                            executor2.run(new Runnable(){

                                @Override
                                public void run() {
                                    List<WatchEvent<?>> list = watchKey.pollEvents();
                                    Iterator<WatchEvent<?>> iterator = list.iterator();
                                    if (!watchKey.reset()) {
                                        watchKey.cancel();
                                    }
                                    while (iterator.hasNext()) {
                                        WatchEvent<?> watchEvent = iterator.next();
                                        WatchEvent.Kind<?> kind = watchEvent.kind();
                                        DirectoryWatcher.Event.Kind kind2 = kind.equals(StandardWatchEventKinds.ENTRY_DELETE) ? DirectoryWatcher.Event.Delete : (kind.equals(StandardWatchEventKinds.ENTRY_CREATE) ? DirectoryWatcher.Event.Create : (kind.equals(StandardWatchEventKinds.OVERFLOW) ? DirectoryWatcher.Event.Overflow : DirectoryWatcher.Event.Modify));
                                        Path path = (Path)watchKey.watchable();
                                        if (!kind2.equals(DirectoryWatcher.Event.Overflow) || !Files.exists(path, new LinkOption[0])) {
                                            Path path2 = watchEvent.context() == null ? path : path.resolve((Path)watchEvent.context());
                                            NioDirectoryWatcherImpl.this.handleEvent(consumer, path2, kind2);
                                            continue;
                                        }
                                        NioDirectoryWatcherImpl.this.handleOverflow(consumer, path);
                                    }
                                }
                            });
                            bl2 = true;
                        }
                    }
                    catch (InterruptedException | ClosedWatchServiceException exception) {
                        bl = true;
                    }
                }
                NioDirectoryWatcherImpl.this.shutdownLatch.countDown();
            }
        };
        this.loopThread.setDaemon(true);
        this.loopThread.start();
        countDownLatch.await(5L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.isStopped.compareAndSet(false, true)) {
            this.loopThread.interrupt();
            super.close();
            try {
                this.watchService.close();
                this.shutdownLatch.await(5L, TimeUnit.SECONDS);
                this.loopThread.join(5000L);
            }
            catch (IOException | InterruptedException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

