/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.Directory;
import com.swoval.files.DirectoryWatcher;
import com.swoval.files.EntryFilters;
import com.swoval.files.FileCacheImpl;
import com.swoval.files.Observers;
import com.swoval.functional.Either;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public abstract class FileCache<T>
implements AutoCloseable {
    final Observers<T> observers = new Observers();

    public int addObserver(Directory.Observer<T> observer) {
        return this.observers.addObserver(observer);
    }

    public int addCallback(final Directory.OnChange<T> onChange) {
        return this.addObserver(new Directory.Observer<T>(){

            @Override
            public void onCreate(Directory.Entry<T> entry) {
                onChange.apply(entry);
            }

            @Override
            public void onDelete(Directory.Entry<T> entry) {
                onChange.apply(entry);
            }

            @Override
            public void onUpdate(Directory.Entry<T> entry, Directory.Entry<T> entry2) {
                onChange.apply(entry2);
            }

            @Override
            public void onError(Path path, IOException iOException) {
            }
        });
    }

    public void removeObserver(int n) {
        this.observers.removeObserver(n);
    }

    public abstract List<Directory.Entry<T>> list(Path var1, int var2, Directory.EntryFilter<? super T> var3);

    public List<Directory.Entry<T>> list(Path path, boolean bl, Directory.EntryFilter<? super T> entryFilter) {
        return this.list(path, bl ? Integer.MAX_VALUE : 0, entryFilter);
    }

    public List<Directory.Entry<T>> list(Path path, int n) {
        return this.list(path, n, EntryFilters.AllPass);
    }

    public List<Directory.Entry<T>> list(Path path, boolean bl) {
        return this.list(path, bl, EntryFilters.AllPass);
    }

    public List<Directory.Entry<T>> list(Path path) {
        return this.list(path, Integer.MAX_VALUE, EntryFilters.AllPass);
    }

    public abstract Either<IOException, Boolean> register(Path var1, int var2);

    public Either<IOException, Boolean> register(Path path, boolean bl) {
        return this.register(path, bl ? Integer.MAX_VALUE : 0);
    }

    public Either<IOException, Boolean> register(Path path) {
        return this.register(path, Integer.MAX_VALUE);
    }

    @Override
    public void close() {
    }

    public static <T> FileCache<T> apply(Directory.Converter<T> converter, Option ... optionArray) throws IOException, InterruptedException {
        return new FileCacheImpl<T>(converter, DirectoryWatcher.DEFAULT_FACTORY, null, optionArray);
    }

    public static <T> FileCache<T> apply(Directory.Converter<T> converter, DirectoryWatcher.Factory factory, Option ... optionArray) throws IOException, InterruptedException {
        return new FileCacheImpl<T>(converter, factory, null, optionArray);
    }

    public static <T> FileCache<T> apply(Directory.Converter<T> converter, Directory.Observer<T> observer, Option ... optionArray) throws IOException, InterruptedException {
        FileCacheImpl<T> fileCacheImpl = new FileCacheImpl<T>(converter, DirectoryWatcher.DEFAULT_FACTORY, null, optionArray);
        fileCacheImpl.addObserver(observer);
        return fileCacheImpl;
    }

    public static <T> FileCache<T> apply(Directory.Converter<T> converter, DirectoryWatcher.Factory factory, Directory.Observer<T> observer, Option ... optionArray) throws IOException, InterruptedException {
        FileCacheImpl<T> fileCacheImpl = new FileCacheImpl<T>(converter, factory, null, optionArray);
        fileCacheImpl.addObserver(observer);
        return fileCacheImpl;
    }

    public static class Option {
        public static final Option NOFOLLOW_LINKS = new Option();

        Option() {
        }
    }
}

