/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.AppleDirectoryWatcher;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.Executor;
import com.swoval.files.PlatformWatcher;
import com.swoval.functional.Consumer;
import com.swoval.functional.Either;
import com.swoval.runtime.Platform;
import java.io.IOException;
import java.nio.file.Path;

public abstract class DirectoryWatcher
implements AutoCloseable {
    public static final Factory DEFAULT_FACTORY = new Factory(){

        @Override
        public DirectoryWatcher create(Consumer<Event> consumer, Executor executor, DirectoryRegistry directoryRegistry) throws InterruptedException, IOException {
            return DirectoryWatcher.defaultWatcher(consumer, executor, directoryRegistry, new Option[0]);
        }
    };

    public abstract Either<IOException, Boolean> register(Path var1, int var2);

    public Either<IOException, Boolean> register(Path path, boolean bl) {
        return this.register(path, bl ? Integer.MAX_VALUE : 0);
    }

    public Either<IOException, Boolean> register(Path path) {
        return this.register(path, true);
    }

    public abstract void unregister(Path var1);

    @Override
    public void close() {
    }

    public static DirectoryWatcher defaultWatcher(Consumer<Event> consumer, Option ... optionArray) throws IOException, InterruptedException {
        return DirectoryWatcher.defaultWatcher(consumer, Executor.make("com.swoval.files.DirectoryWatcher-internal-executor"), new DirectoryRegistry(), optionArray);
    }

    static DirectoryWatcher defaultWatcher(Consumer<Event> consumer, Executor executor, Option ... optionArray) throws IOException, InterruptedException {
        return DirectoryWatcher.defaultWatcher(consumer, executor, new DirectoryRegistry(), optionArray);
    }

    static DirectoryWatcher defaultWatcher(Consumer<Event> consumer, Executor executor, DirectoryRegistry directoryRegistry, Option ... optionArray) throws IOException, InterruptedException {
        return Platform.isMac() ? new AppleDirectoryWatcher(consumer, executor, directoryRegistry, optionArray) : PlatformWatcher.make(consumer, (Executor)executor, (DirectoryRegistry)directoryRegistry, (Option[])optionArray);
    }

    public static final class Options {
        public static final Option POLL_NEW_DIRECTORIES = new Option("POLL_NEW_DIRECTORIES");
    }

    public static class Option {
        private final String name;

        public Option(String string) {
            this.name = string;
        }

        public boolean equals(Object object) {
            return object instanceof Option && ((Option)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class Event {
        public final Path path;
        public final Kind kind;
        public static final Kind Create = new Kind("Create", 1);
        public static final Kind Delete = new Kind("Delete", 2);
        public static final Kind Error = new Kind("Error", 4);
        public static final Kind Modify = new Kind("Modify", 3);
        public static final Kind Overflow = new Kind("Overflow", 0);

        public Event(Path path, Kind kind) {
            this.path = path;
            this.kind = kind;
        }

        public boolean equals(Object object) {
            if (object instanceof Event) {
                Event event = (Event)object;
                return this.path.equals(event.path) && this.kind.equals(event.kind);
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode() ^ this.kind.hashCode();
        }

        public String toString() {
            return "Event(" + this.path + ", " + this.kind + ")";
        }

        public static class Kind
        implements Comparable<Kind> {
            private final String name;
            private final int priority;

            Kind(String string, int n) {
                this.name = string;
                this.priority = n;
            }

            public String toString() {
                return this.name;
            }

            public boolean equals(Object object) {
                return object instanceof Kind && ((Kind)object).name.equals(this.name);
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            @Override
            public int compareTo(Kind kind) {
                return Integer.compare(this.priority, kind.priority);
            }
        }
    }

    public static abstract class Factory {
        public DirectoryWatcher create(Consumer<Event> consumer, Executor executor) throws InterruptedException, IOException {
            return this.create(consumer, executor, new DirectoryRegistry());
        }

        public abstract DirectoryWatcher create(Consumer<Event> var1, Executor var2, DirectoryRegistry var3) throws InterruptedException, IOException;
    }
}

