/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.cloud.sb.broker.security;

import com.swisscom.cloud.sb.broker.config.ApplicationUserConfig;
import com.swisscom.cloud.sb.broker.config.UserConfig;
import com.swisscom.cloud.sb.broker.model.ApplicationUser;
import com.swisscom.cloud.sb.broker.repository.ApplicationUserRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class ApplicationUserInitializer
implements GroovyObject {
    private static final Logger LOGGER;
    private ApplicationUserRepository userRepository;
    private ApplicationUserConfig applicationUserConfig;
    private PasswordEncoder passwordEncoder;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Autowired
    public ApplicationUserInitializer(ApplicationUserRepository userRepository, ApplicationUserConfig applicationUserConfig, PasswordEncoder passwordEncoder) {
        PasswordEncoder passwordEncoder2;
        ApplicationUserConfig applicationUserConfig2;
        ApplicationUserRepository applicationUserRepository;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.userRepository = applicationUserRepository = userRepository;
        this.applicationUserConfig = applicationUserConfig2 = applicationUserConfig;
        this.passwordEncoder = passwordEncoder2 = passwordEncoder;
    }

    @PostConstruct
    public void init() throws Exception {
        LOGGER.info("Synchronizing {}", (Object)this.applicationUserConfig.toString());
        this.checkForDuplicatedApplicationUserConfigurations();
        this.synchronizeApplicationUsers();
    }

    public void checkForDuplicatedApplicationUserConfigurations() {
        public final class _checkForDuplicatedApplicationUserConfigurations_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _checkForDuplicatedApplicationUserConfigurations_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object configUser) {
                Reference configUser2 = new Reference(configUser);
                public final class _closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference configUser;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure4(Object _outerInstance, Object _thisObject, Reference configUser) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.configUser = reference = configUser;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((UserConfig)it).getUsername(), (Object)((UserConfig)this.configUser.get()).getUsername());
                    }

                    @Generated
                    public Object getConfigUser() {
                        return this.configUser.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.findAll(((ApplicationUserInitializer)this.getThisObject()).applicationUserConfig.getPlatformUsers(), (Closure)new _closure4((Object)this, this.getThisObject(), configUser2)).size() > 1;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkForDuplicatedApplicationUserConfigurations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List duplicatedUserConfigurations = DefaultGroovyMethods.findAll(this.applicationUserConfig.getPlatformUsers(), (Closure)new _checkForDuplicatedApplicationUserConfigurations_closure1(this, this));
        if (duplicatedUserConfigurations.size() > 0) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{duplicatedUserConfigurations}, new String[]{"Duplicated application users defined - ", ""})));
        }
    }

    public void disableApplicationUser(ApplicationUser user) {
        Boolean bl = user.getEnabled();
        if (bl == null ? false : bl) {
            boolean bl2 = false;
            user.setEnabled(Boolean.valueOf(bl2));
            this.userRepository.saveAndFlush(user);
        }
    }

    public void synchronizeApplicationUsers() {
        Reference allDbUser = new Reference((Object)this.userRepository.findAll());
        public final class _synchronizeApplicationUsers_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference allDbUser;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _synchronizeApplicationUsers_closure2(Object _outerInstance, Object _thisObject, Reference allDbUser) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.allDbUser = reference = allDbUser;
            }

            public Object doCall(Object configUser) {
                Reference configUser2 = new Reference(configUser);
                public final class _closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference configUser;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure5(Object _outerInstance, Object _thisObject, Reference configUser) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.configUser = reference = configUser;
                    }

                    public Object doCall(Object user) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((ApplicationUser)user).getUsername(), (Object)((UserConfig)this.configUser.get()).getUsername());
                    }

                    @Generated
                    public Object getConfigUser() {
                        return this.configUser.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ApplicationUser dbUser = (ApplicationUser)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)this.allDbUser.get(), Collection.class)), (Closure)new _closure5((Object)this, this.getThisObject(), configUser2)), ApplicationUser.class);
                if (dbUser == null) {
                    ((ApplicationUserInitializer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ApplicationUserInitializer.class)).addApplicationUser(((UserConfig)configUser2.get()).getPlatformId(), (UserConfig)ScriptBytecodeAdapter.castToType((Object)configUser2.get(), UserConfig.class));
                    return null;
                }
                ((ApplicationUserInitializer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ApplicationUserInitializer.class)).synchronizeApplicationUser(dbUser, (UserConfig)ScriptBytecodeAdapter.castToType((Object)configUser2.get(), UserConfig.class));
                return ((List)this.allDbUser.get()).remove(dbUser);
            }

            @Generated
            public Object getAllDbUser() {
                return this.allDbUser.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _synchronizeApplicationUsers_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.applicationUserConfig.getPlatformUsers(), (Closure)new _synchronizeApplicationUsers_closure2(this, this, allDbUser));
        public final class _synchronizeApplicationUsers_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _synchronizeApplicationUsers_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object oldUser) {
                ((ApplicationUserInitializer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ApplicationUserInitializer.class)).disableApplicationUser((ApplicationUser)ScriptBytecodeAdapter.castToType((Object)oldUser, ApplicationUser.class));
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _synchronizeApplicationUsers_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)((List)allDbUser.get()), (Closure)new _synchronizeApplicationUsers_closure3(this, this));
    }

    public void synchronizeApplicationUser(ApplicationUser user, UserConfig userConfig) {
        boolean changed = false;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)user.getPassword(), (Object)this.passwordEncoder.encode((CharSequence)userConfig.getPassword()))) {
            boolean bl;
            String string = this.passwordEncoder.encode((CharSequence)userConfig.getPassword());
            user.setPassword(string);
            changed = bl = true;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)user.getRole(), (Object)userConfig.getRole())) {
            boolean bl;
            String string = userConfig.getRole();
            user.setRole(string);
            changed = bl = true;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)user.getPlatformGuid(), (Object)userConfig.getPlatformId())) {
            boolean bl;
            String string = userConfig.getPlatformId();
            user.setPlatformGuid(string);
            changed = bl = true;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)user.getEnabled())) {
            boolean bl;
            boolean bl2 = true;
            user.setEnabled(Boolean.valueOf(bl2));
            changed = bl = true;
        }
        if (changed) {
            this.userRepository.saveAndFlush(user);
        }
    }

    public void addApplicationUser(String platformGuid, UserConfig userConfig) {
        ApplicationUser user = new ApplicationUser();
        String string = userConfig.getUsername();
        user.setUsername(string);
        String string2 = this.passwordEncoder.encode((CharSequence)userConfig.getPassword());
        user.setPassword(string2);
        boolean bl = true;
        user.setEnabled(Boolean.valueOf(bl));
        String string3 = userConfig.getRole();
        user.setRole(string3);
        String string4 = platformGuid;
        user.setPlatformGuid(string4);
        this.userRepository.saveAndFlush(user);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ApplicationUserInitializer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        LOGGER = logger = LoggerFactory.getLogger(ApplicationUserInitializer.class);
    }
}

