/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerTimerTask;
import hudson.util.TimeUnit2;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritTriggerTimer {
    private static final long DELAY_MILLISECONDS = 5000L;
    private static final Logger logger = LoggerFactory.getLogger(GerritTriggerTimer.class);
    private static GerritTriggerTimer instance = null;
    private Timer timer = new Timer(true);

    private GerritTriggerTimer() {
    }

    public static GerritTriggerTimer getInstance() {
        if (instance == null) {
            instance = new GerritTriggerTimer();
        }
        return instance;
    }

    private long calculateDynamicConfigRefreshInterval(GerritTriggerTimerTask timerTask) {
        GerritTrigger trigger = timerTask.getGerritTrigger();
        if (trigger != null && trigger.isAnyServer()) {
            List<GerritServer> servers = PluginImpl.getServers_();
            if (servers.isEmpty()) {
                return 30L;
            }
            return this.calculateAverageDynamicConfigRefreshInterval();
        }
        if (trigger == null) {
            return this.calculateAverageDynamicConfigRefreshInterval();
        }
        GerritServer server = PluginImpl.getServer_(trigger.getServerName());
        if (server != null) {
            return server.getConfig().getDynamicConfigRefreshInterval();
        }
        return this.calculateAverageDynamicConfigRefreshInterval();
    }

    private long calculateAverageDynamicConfigRefreshInterval() {
        long total = 0L;
        for (GerritServer server : PluginImpl.getServers_()) {
            total += (long)server.getConfig().getDynamicConfigRefreshInterval();
        }
        long average = total / (long)Math.max(1, PluginImpl.getServers_().size());
        return Math.max(5L, average);
    }

    public void schedule(GerritTriggerTimerTask timerTask) {
        long timerPeriod = TimeUnit2.SECONDS.toMillis(this.calculateDynamicConfigRefreshInterval(timerTask));
        try {
            this.timer.schedule((TimerTask)timerTask, 5000L, timerPeriod);
        }
        catch (IllegalArgumentException iae) {
            logger.error("Attempted use of negative delay", (Throwable)iae);
        }
        catch (IllegalStateException ise) {
            logger.error("Attempted re-use of TimerTask", (Throwable)ise);
        }
    }
}

