/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.listeners.ItemListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GerritItemListener
extends ItemListener {
    private static final Logger logger = LoggerFactory.getLogger(GerritItemListener.class);

    public void onDeleted(Item item) {
        Job project;
        GerritTrigger gerritTrigger;
        if (item instanceof Job && (gerritTrigger = GerritTrigger.getTrigger(project = (Job)item)) != null) {
            gerritTrigger.stop();
        }
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        Job project;
        GerritTrigger gerritTrigger;
        if (item instanceof Job && (gerritTrigger = GerritTrigger.getTrigger(project = (Job)item)) != null) {
            gerritTrigger.onJobRenamed(oldFullName, newFullName);
        }
    }

    public void onLoaded() {
        for (GerritServer s : PluginImpl.getServers_()) {
            if (s.isNoConnectionOnStartup()) continue;
            s.startConnection();
        }
        super.onLoaded();
    }
}

