/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionChecker;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionNumber;
import com.sonymobile.tools.gerrit.gerritevents.ConnectionListener;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritConnectionListener
implements ConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(GerritConnectionListener.class);
    private String serverName;
    private boolean connected;
    private boolean gerritSnapshotVersion;
    private List<GerritVersionChecker.Feature> disabledFeatures;

    public GerritConnectionListener(String serverName) {
        this.serverName = serverName;
    }

    public String getName() {
        return this.serverName;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isSnapShotGerrit() {
        return this.gerritSnapshotVersion;
    }

    public List<GerritVersionChecker.Feature> getDisabledFeatures() {
        return this.disabledFeatures;
    }

    public void connectionEstablished() {
        this.connected = true;
        this.checkGerritVersionFeatures();
    }

    public void connectionDown() {
        this.connected = false;
        this.checkGerritVersionFeatures();
    }

    @CheckForNull
    private String getVersionString() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.error("INITIALIZATION Error, the plugin instance couldn't be found!");
            return null;
        }
        GerritServer server = plugin.getServer(this.serverName);
        if (server != null) {
            return server.getGerritVersion();
        }
        logger.error("server does not exist");
        return null;
    }

    public void checkGerritVersionFeatures() {
        if (this.connected) {
            GerritVersionNumber version = GerritVersionChecker.createVersionNumber(this.getVersionString());
            LinkedList<GerritVersionChecker.Feature> list = new LinkedList<GerritVersionChecker.Feature>();
            for (GerritVersionChecker.Feature f : GerritVersionChecker.Feature.values()) {
                if (GerritVersionChecker.isCorrectVersion(version, f)) continue;
                list.add(f);
            }
            this.disabledFeatures = list;
            this.gerritSnapshotVersion = version.isSnapshot();
        } else {
            this.disabledFeatures = null;
            this.gerritSnapshotVersion = false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int tmp = this.serverName == null ? 0 : this.serverName.hashCode();
        result = 31 * result + tmp;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GerritConnectionListener other = (GerritConnectionListener)obj;
        return !(this.serverName == null ? other.serverName != null : !this.serverName.equals(other.serverName));
    }
}

