/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.Logic;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildMemory {
    private TreeMap<GerritTriggeredEvent, MemoryImprint> memory = new TreeMap(new GerritTriggeredEventComparator());
    private static final Logger logger = LoggerFactory.getLogger(BuildMemory.class);

    public synchronized MemoryImprint getMemoryImprint(GerritTriggeredEvent event) {
        return this.memory.get(event);
    }

    public synchronized boolean isAllBuildsCompleted(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            return pb.isAllBuildsCompleted();
        }
        return false;
    }

    public synchronized BuildsStartedStats getBuildsStartedStats(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            return pb.getBuildsStartedStats();
        }
        return null;
    }

    public synchronized String getStatusReport(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            return pb.getStatusReport();
        }
        return null;
    }

    public synchronized boolean isAllBuildsStarted(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            return pb.isAllBuildsSet();
        }
        return false;
    }

    public synchronized void completed(GerritTriggeredEvent event, Run build) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(event, pb);
        }
        pb.set(build.getParent(), build, true);
    }

    public synchronized void started(GerritTriggeredEvent event, Run build) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            pb = new MemoryImprint(event);
            logger.warn("Build started without being registered first.");
            this.memory.put(event, pb);
        }
        pb.set(build.getParent(), build);
    }

    public synchronized void triggered(GerritTriggeredEvent event, Job project) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(event, pb);
        }
        pb.set(project);
    }

    public synchronized void retriggered(GerritTriggeredEvent event, Job project, List<Run> otherBuilds) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(event, pb);
            if (otherBuilds != null) {
                for (Run build : otherBuilds) {
                    pb.set(build.getParent(), build, !build.isBuilding());
                }
            }
        }
        pb.reset(project);
    }

    public synchronized void forget(GerritTriggeredEvent event) {
        this.memory.remove(event);
    }

    public synchronized void updateTriggerContext(GerritCause cause, Run r) {
        MemoryImprint imprint = this.getMemoryImprint(cause.getEvent());
        TriggerContext context = cause.getContext();
        context.setThisBuild(r);
        for (MemoryImprint.Entry entry : imprint.getEntries()) {
            Run build = entry.getBuild();
            if (build != null && !build.equals(r)) {
                context.addOtherBuild(build);
                this.updateTriggerContext(entry, imprint);
                continue;
            }
            Job project = entry.getProject();
            if (build != null || project == null || project.equals(r.getParent())) continue;
            context.addOtherProject(project);
        }
        if (!r.hasntStartedYet() && !r.isBuilding()) {
            try {
                r.save();
            }
            catch (IOException ex) {
                logger.error("Could not save build state for build " + r, (Throwable)ex);
            }
        }
    }

    private synchronized void updateTriggerContext(@Nonnull MemoryImprint.Entry entryToUpdate, @Nonnull MemoryImprint imprint) {
        GerritCause cause;
        Run build = entryToUpdate.getBuild();
        if (build != null && (cause = (GerritCause)build.getCause(GerritCause.class)) != null) {
            TriggerContext context = cause.getContext();
            for (MemoryImprint.Entry ent : imprint.getEntries()) {
                Run entBuild = ent.getBuild();
                if (entBuild != null && !entBuild.equals(build)) {
                    context.addOtherBuild(entBuild);
                    continue;
                }
                Job entProject = ent.getProject();
                if (entBuild != null || entProject == null || entProject.equals(entryToUpdate.getProject())) continue;
                context.addOtherProject(entProject);
            }
            if (!build.hasntStartedYet() && !build.isBuilding()) {
                try {
                    build.save();
                }
                catch (IOException ex) {
                    logger.error("Could not save state for build " + build, (Throwable)ex);
                }
            }
        }
    }

    public synchronized boolean isTriggered(@Nonnull GerritTriggeredEvent event, @Nonnull Job project) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            return false;
        }
        for (MemoryImprint.Entry entry : pb.getEntries()) {
            if (!project.equals(entry.getProject())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isBuilding(GerritTriggeredEvent event, Job project) {
        MemoryImprint pb = this.memory.get(event);
        if (pb == null) {
            return false;
        }
        for (MemoryImprint.Entry entry : pb.getEntries()) {
            if (!entry.isProject(project)) continue;
            if (entry.getBuild() != null) {
                return !entry.isBuildCompleted();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isBuilding(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        return pb != null;
    }

    public synchronized List<Run> getBuilds(GerritTriggeredEvent event) {
        MemoryImprint pb = this.memory.get(event);
        if (pb != null) {
            LinkedList<Run> list = new LinkedList<Run>();
            for (MemoryImprint.Entry entry : pb.getEntries()) {
                if (entry.getBuild() == null) continue;
                list.add(entry.getBuild());
            }
            return list;
        }
        return null;
    }

    public void setEntryFailureMessage(GerritTriggeredEvent event, Run r, String failureMessage) {
        MemoryImprint.Entry entry;
        MemoryImprint pb = this.getMemoryImprint(event);
        if (pb != null && (entry = pb.getEntry(r.getParent())) != null) {
            logger.info("Recording unsuccessful message for {}: {}", (Object)event, (Object)failureMessage);
            entry.setUnsuccessfulMessage(failureMessage);
        }
    }

    public static class MemoryImprint {
        private GerritTriggeredEvent event;
        private List<Entry> list = new ArrayList<Entry>();

        public MemoryImprint(GerritTriggeredEvent event) {
            this.event = event;
        }

        public MemoryImprint(GerritTriggeredEvent event, Job project) {
            this.event = event;
            this.set(project);
        }

        public GerritTriggeredEvent getEvent() {
            return this.event;
        }

        public synchronized Entry[] getEntries() {
            return this.list.toArray(new Entry[this.list.size()]);
        }

        protected synchronized void set(Job project, Run build) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project, build);
                this.list.add(entry);
            } else {
                entry.setBuild(build);
            }
        }

        protected synchronized void set(Job project) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project);
                this.list.add(entry);
            }
        }

        protected synchronized void reset(Job project) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project);
                this.list.add(entry);
            } else {
                entry.setBuild(null);
                entry.setBuildCompleted(false);
            }
        }

        private synchronized void set(Job project, Run build, boolean buildCompleted) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project, build);
                entry.setBuildCompleted(buildCompleted);
                this.list.add(entry);
            } else {
                if (entry.getBuild() == null) {
                    entry.setBuild(build);
                }
                entry.setBuildCompleted(buildCompleted);
            }
        }

        public synchronized boolean isAllBuildsSet() {
            for (Entry entry : this.list) {
                if (entry.getBuild() != null) continue;
                return false;
            }
            return true;
        }

        public synchronized boolean isAllBuildsCompleted() {
            for (Entry entry : this.list) {
                if (entry.isBuildCompleted()) continue;
                return false;
            }
            return true;
        }

        public synchronized String getStatusReport() {
            StringBuilder str = new StringBuilder("");
            for (Entry entry : this.list) {
                if (entry == null) continue;
                Job project = entry.getProject();
                if (project != null) {
                    str.append("  Project/Build: [").append(project.getName()).append("]");
                    str.append(": [#");
                    Run build = entry.getBuild();
                    if (build != null) {
                        str.append(build.getNumber());
                        str.append(": ").append(build.getResult());
                    } else {
                        str.append("XX: NULL");
                    }
                    str.append("] Completed: ").append(entry.isBuildCompleted());
                } else {
                    str.append("  Project/Build: MISSING PROJECT!");
                }
                str.append("\n");
            }
            return str.toString();
        }

        private Entry getEntry(@Nonnull Job project) {
            for (Entry entry : this.list) {
                if (entry == null || !project.equals(entry.getProject())) continue;
                return entry;
            }
            return null;
        }

        public synchronized BuildsStartedStats getBuildsStartedStats() {
            int started = 0;
            for (Entry entry : this.list) {
                if (entry.getBuild() == null) continue;
                ++started;
            }
            return new BuildsStartedStats(this.event, this.list.size(), started);
        }

        public synchronized boolean areAllBuildResultsSkipped() {
            for (Entry entry : this.list) {
                if (entry == null) continue;
                Run build = entry.getBuild();
                if (build == null) {
                    return false;
                }
                if (!entry.isBuildCompleted()) {
                    return false;
                }
                Result buildResult = build.getResult();
                GerritTrigger trigger = GerritTrigger.getTrigger(entry.getProject());
                if (Logic.shouldSkip(trigger.getSkipVote(), buildResult)) continue;
                return false;
            }
            return true;
        }

        public synchronized boolean wereAllBuildsSuccessful() {
            if (this.areAllBuildResultsSkipped()) {
                for (Entry entry : this.list) {
                    if (entry == null) continue;
                    Run build = entry.getBuild();
                    if (build == null) {
                        return false;
                    }
                    if (!entry.isBuildCompleted()) {
                        return false;
                    }
                    Result buildResult = build.getResult();
                    if (buildResult == Result.SUCCESS) continue;
                    return false;
                }
            } else {
                for (Entry entry : this.list) {
                    GerritTrigger trigger;
                    if (entry == null) continue;
                    Run build = entry.getBuild();
                    if (build == null) {
                        return false;
                    }
                    if (!entry.isBuildCompleted()) {
                        return false;
                    }
                    Result buildResult = build.getResult();
                    if (buildResult == Result.SUCCESS || Logic.shouldSkip((trigger = GerritTrigger.getTrigger(entry.getProject())).getSkipVote(), buildResult)) continue;
                    return false;
                }
            }
            return true;
        }

        public synchronized boolean wereAnyBuildsFailed() {
            for (Entry entry : this.list) {
                Run build;
                if (entry == null || (build = entry.getBuild()) == null || !entry.isBuildCompleted() || build.getResult() != Result.FAILURE) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean wereAnyBuildsUnstable() {
            for (Entry entry : this.list) {
                Run build;
                if (entry == null || (build = entry.getBuild()) == null || !entry.isBuildCompleted() || build.getResult() != Result.UNSTABLE) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean wereAllBuildsNotBuilt() {
            for (Entry entry : this.list) {
                if (entry == null) continue;
                Run build = entry.getBuild();
                if (build == null) {
                    return false;
                }
                if (!entry.isBuildCompleted()) {
                    return false;
                }
                Result buildResult = build.getResult();
                if (buildResult == Result.NOT_BUILT) continue;
                return false;
            }
            return true;
        }

        public static class Entry {
            private String project;
            private String build;
            private boolean buildCompleted;
            private String unsuccessfulMessage;

            private Entry(Job project, Run build) {
                this.project = project.getFullName();
                this.build = build.getId();
                this.buildCompleted = false;
            }

            private Entry(Job project) {
                this.project = project.getFullName();
                this.buildCompleted = false;
            }

            @CheckForNull
            @WithBridgeMethods(value={AbstractProject.class})
            public Job getProject() {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null) {
                    return (Job)jenkins.getItemByFullName(this.project, Job.class);
                }
                return null;
            }

            @CheckForNull
            @WithBridgeMethods(value={AbstractBuild.class})
            public Run getBuild() {
                Job p = this.getProject();
                if (p != null && this.build != null) {
                    return p.getBuild(this.build);
                }
                return null;
            }

            private void setBuild(Run build) {
                this.build = build != null ? build.getId() : null;
            }

            private void setUnsuccessfulMessage(String unsuccessfulMessage) {
                this.unsuccessfulMessage = unsuccessfulMessage;
            }

            public String getUnsuccessfulMessage() {
                return this.unsuccessfulMessage;
            }

            public boolean isBuildCompleted() {
                return this.buildCompleted;
            }

            private void setBuildCompleted(boolean buildCompleted) {
                this.buildCompleted = buildCompleted;
            }

            public String toString() {
                String s = "";
                Run theBuild = this.getBuild();
                if (theBuild != null) {
                    s = theBuild.toString();
                } else {
                    Job theProject = this.getProject();
                    if (theProject != null) {
                        s = theProject.getName();
                    }
                }
                if (this.isBuildCompleted()) {
                    s = s + " (completed)";
                }
                return s;
            }

            public boolean isProject(Job other) {
                if (this.project != null && other != null) {
                    return this.project.equals(other.getFullName());
                }
                return this.project == null && other == null;
            }
        }
    }

    static class GerritTriggeredEventComparator
    implements Comparator<GerritTriggeredEvent> {
        GerritTriggeredEventComparator() {
        }

        @Override
        public int compare(GerritTriggeredEvent o1, GerritTriggeredEvent o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            return Integer.valueOf(o1.hashCode()).compareTo(o2.hashCode());
        }
    }
}

