/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.job.rest;

import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritMessageProvider;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ParameterExpander;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.CommentedFile;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Notify;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ReviewInput;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ReviewLabel;
import com.sonymobile.tools.gerrit.gerritevents.rest.RestConnectionConfig;
import com.sonymobile.tools.gerrit.gerritevents.workers.rest.AbstractRestCommandJob;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.List;

public class BuildCompletedRestCommandJob
extends AbstractRestCommandJob {
    private static final String LABEL_CODEREVIEW = "Code-Review";
    private static final String LABEL_VERIFIED = "Verified";
    private final BuildMemory.MemoryImprint memoryImprint;
    private final TaskListener listener;
    private final ParameterExpander parameterExpander;
    private final IGerritHudsonTriggerConfig config;

    public BuildCompletedRestCommandJob(IGerritHudsonTriggerConfig config, BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        super((RestConnectionConfig)config, listener != null ? listener.getLogger() : null, (ChangeBasedEvent)memoryImprint.getEvent());
        this.memoryImprint = memoryImprint;
        this.listener = listener;
        this.parameterExpander = new ParameterExpander(config);
        this.config = config;
    }

    protected ReviewInput createReview() {
        String message = this.parameterExpander.getBuildCompletedMessage(this.memoryImprint, this.listener);
        ArrayList<ReviewLabel> scoredLabels = new ArrayList<ReviewLabel>();
        if (this.memoryImprint.getEvent().isScorable()) {
            if (this.config.isRestCodeReview()) {
                scoredLabels.add(new ReviewLabel(LABEL_CODEREVIEW, this.parameterExpander.getMinimumCodeReviewValue(this.memoryImprint, true)));
            }
            if (this.config.isRestVerified()) {
                scoredLabels.add(new ReviewLabel(LABEL_VERIFIED, this.parameterExpander.getMinimumVerifiedValue(this.memoryImprint, true)));
            }
        }
        Notify notificationLevel = this.parameterExpander.getHighestNotificationLevel(this.memoryImprint, true);
        List<GerritMessageProvider> gerritMessageProviders = GerritMessageProvider.all();
        ArrayList<CommentedFile> commentedFiles = new ArrayList<CommentedFile>();
        if (gerritMessageProviders != null) {
            for (GerritMessageProvider gerritMessageProvider : gerritMessageProviders) {
                for (BuildMemory.MemoryImprint.Entry e : this.memoryImprint.getEntries()) {
                    try {
                        commentedFiles.addAll(gerritMessageProvider.getFileComments(e.getBuild()));
                    }
                    catch (Exception ef) {
                        this.listener.error(ef.getMessage());
                    }
                }
            }
        }
        return new ReviewInput(message, scoredLabels, commentedFiles).setNotify(notificationLevel);
    }
}

