/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritNotifier;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.job.rest.BuildCompletedRestCommandJob;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.job.rest.BuildStartedRestCommandJob;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.job.ssh.BuildCompletedCommandJob;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.job.ssh.BuildStartedCommandJob;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonymobile.tools.gerrit.gerritevents.GerritCmdRunner;
import com.sonymobile.tools.gerrit.gerritevents.GerritSendCommandQueue;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.workers.cmd.AbstractSendCommandJob;
import com.sonymobile.tools.gerrit.gerritevents.workers.rest.AbstractRestCommandJob;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationFactory {
    private static final Logger logger = LoggerFactory.getLogger(NotificationFactory.class);
    private static NotificationFactory instance;

    public static NotificationFactory getInstance() {
        if (instance == null) {
            instance = new NotificationFactory();
        }
        return instance;
    }

    public IGerritHudsonTriggerConfig getConfig(String serverName) {
        GerritServer server = PluginImpl.getServer_(serverName);
        if (server != null) {
            return server.getConfig();
        }
        logger.error("Could not find the Gerrit Server: {}", (Object)serverName);
        return null;
    }

    public GerritNotifier createGerritNotifier(GerritCmdRunner cmdRunner, String serverName) {
        IGerritHudsonTriggerConfig config = this.getConfig(serverName);
        return this.createGerritNotifier(config, cmdRunner);
    }

    public GerritNotifier createGerritNotifier(IGerritHudsonTriggerConfig config, GerritCmdRunner cmdRunner) {
        return new GerritNotifier(config, cmdRunner);
    }

    public void queueBuildCompleted(BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        String serverName = this.getServerName(memoryImprint);
        if (serverName != null) {
            IGerritHudsonTriggerConfig config = this.getConfig(serverName);
            if (config != null) {
                if (config.isUseRestApi()) {
                    GerritSendCommandQueue.queue((AbstractRestCommandJob)new BuildCompletedRestCommandJob(config, memoryImprint, listener));
                } else {
                    GerritSendCommandQueue.queue((AbstractSendCommandJob)new BuildCompletedCommandJob(config, memoryImprint, listener));
                }
            } else {
                logger.warn("Nothing queued since there is no configuration for serverName: {}", (Object)serverName);
            }
        } else {
            logger.warn("Nothing queued since the event in memory contained no serverName: {}", (Object)memoryImprint);
        }
    }

    private String getServerName(BuildMemory.MemoryImprint memoryImprint) {
        if (memoryImprint != null) {
            GerritTriggeredEvent event = memoryImprint.getEvent();
            if (event != null) {
                return this.getServerName(event);
            }
            logger.error("Could not get the GerritTriggeredEvent from memoryImprint");
        } else {
            logger.error("The memory imprint is null");
        }
        return null;
    }

    private String getServerName(GerritTriggeredEvent event) {
        if (event != null) {
            Provider prov = event.getProvider();
            if (prov != null) {
                String serverName = prov.getName();
                if (serverName != null) {
                    return serverName;
                }
                logger.warn("Could not find the Gerrit Server name from the provider {}", (Object)prov);
            } else {
                logger.warn("Could not get the Provider from event {}", (Object)event);
            }
        }
        return null;
    }

    public void queueBuildStarted(Run build, TaskListener listener, GerritTriggeredEvent event, BuildsStartedStats stats) {
        String serverName = this.getServerName(event);
        if (serverName != null) {
            IGerritHudsonTriggerConfig config = this.getConfig(serverName);
            if (config != null) {
                if (config.isUseRestApi() && event instanceof ChangeBasedEvent) {
                    GerritSendCommandQueue.queue((AbstractRestCommandJob)new BuildStartedRestCommandJob(config, build, listener, (ChangeBasedEvent)event, stats));
                } else {
                    GerritSendCommandQueue.queue((AbstractSendCommandJob)new BuildStartedCommandJob(config, build, listener, event, stats));
                }
            } else {
                logger.warn("Nothing queued since there is no configuration for serverName: {}", (Object)serverName);
            }
        } else {
            logger.warn("Nothing queued since the event contained no serverName: {}", (Object)event);
        }
    }
}

