/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.events;

import com.sonyericsson.hudson.plugins.gerrit.trigger.events.lifecycle.GerritEventLifecycle;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.lifecycle.GerritEventLifecycleListener;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.PatchSet;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.PatchsetCreated;
import hudson.model.Job;
import hudson.model.Run;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;

public class ManualPatchsetCreated
extends PatchsetCreated
implements GerritEventLifecycle {
    private String userName;
    private transient List<GerritEventLifecycleListener> listeners;

    public ManualPatchsetCreated() {
    }

    public ManualPatchsetCreated(JSONObject change, JSONObject patch, String userName) {
        this.fromJson(change, patch);
        this.userName = userName;
    }

    public void fromJson(JSONObject change, JSONObject patch) {
        this.setChange(new Change(change));
        this.setPatchset(new PatchSet(patch));
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("[");
        str.append(this.getClass().getSimpleName());
        str.append(" Change: ").append(this.getChange());
        str.append(" PatchSet: ").append(this.getPatchSet());
        str.append("]");
        return str.toString();
    }

    @Override
    public GerritEvent getEvent() {
        return this;
    }

    @Override
    public synchronized void addListener(GerritEventLifecycleListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<GerritEventLifecycleListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized boolean removeListener(GerritEventLifecycleListener listener) {
        if (this.listeners != null) {
            return this.listeners.remove(listener);
        }
        return false;
    }

    @Override
    public synchronized void fireTriggerScanStarting() {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, GerritEvent event) {
                listener.triggerScanStarting(event);
            }
        });
    }

    @Override
    public synchronized void fireTriggerScanDone() {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, GerritEvent event) {
                listener.triggerScanDone(event);
            }
        });
    }

    public synchronized void fireProjectTriggered(final Job project) {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, GerritEvent event) {
                listener.projectTriggered(event, project);
            }
        });
    }

    public synchronized void fireBuildStarted(final Run build) {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, GerritEvent event) {
                listener.buildStarted(event, build);
            }
        });
    }

    public synchronized void fireBuildCompleted(final Run build) {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, GerritEvent event) {
                listener.buildCompleted(event, build);
            }
        });
    }

    @Override
    public synchronized void fireAllBuildsCompleted() {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, GerritEvent event) {
                listener.allBuildsCompleted(event);
            }
        });
    }

    private synchronized void fireEvent(ListenerVisitor visitor) {
        if (this.listeners != null) {
            List<GerritEventLifecycleListener> list = this.getListeners();
            for (GerritEventLifecycleListener listener : list) {
                visitor.visit(listener, (GerritEvent)this);
            }
        }
    }

    protected synchronized List<GerritEventLifecycleListener> getListeners() {
        if (this.listeners != null) {
            return new LinkedList<GerritEventLifecycleListener>(this.listeners);
        }
        return null;
    }

    private static interface ListenerVisitor {
        public void visit(GerritEventLifecycleListener var1, GerritEvent var2);
    }
}

