/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.sikuli.basics.FileManager;
import org.sikuli.script.ImagePath;
import org.sikuli.script.runners.AbortableScriptRunnerWrapper;
import org.sikuli.script.runners.AbstractScriptRunner;
import org.sikuli.script.support.IScriptRunner;
import org.sikuli.script.support.Runner;

public class NetworkRunner
extends AbstractScriptRunner {
    private AbortableScriptRunnerWrapper wrapper = new AbortableScriptRunnerWrapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected int doRunScript(String scriptFile, String[] scriptArgs, IScriptRunner.Options options) {
        block18: {
            scriptUrl = this.getScriptURL(scriptFile);
            if (null != scriptUrl) {
                block16: {
                    block17: {
                        dir = null;
                        dir = Files.createTempDirectory("sikulix", new FileAttribute[0]).toFile();
                        localFile = FileManager.downloadURL(scriptUrl, dir.getAbsolutePath());
                        if (localFile == null) break block16;
                        runner = Runner.getRunner(localFile);
                        this.wrapper.setRunner(runner);
                        var9_12 = retval = runner.runScript(localFile, scriptArgs, options);
                        this.wrapper.clearRunner();
                        if (null == dir) break block17;
                        try {
                            FileUtils.deleteDirectory((File)dir);
                        }
                        catch (IOException e) {
                            this.log(-1, "Error deleting tmp dir %s: %s", new Object[]{dir, e.getMessage()});
                        }
                    }
                    return var9_12;
                }
                this.wrapper.clearRunner();
                if (null != dir) {
                    try {
                        FileUtils.deleteDirectory((File)dir);
                    }
                    catch (IOException e) {
                        this.log(-1, "Error deleting tmp dir %s: %s", new Object[]{dir, e.getMessage()});
                    }
                }
                break block18;
                catch (IOException e) {
                    try {
                        this.log(-1, "Error creating tmpfile: %s", new Object[]{e.getMessage()});
                        this.wrapper.clearRunner();
                        ** if (null == dir) goto lbl-1000
                    }
                    catch (Throwable var11_14) {
                        this.wrapper.clearRunner();
                        if (null != dir) {
                            try {
                                FileUtils.deleteDirectory((File)dir);
                            }
                            catch (IOException e) {
                                this.log(-1, "Error deleting tmp dir %s: %s", new Object[]{dir, e.getMessage()});
                            }
                        }
                        throw var11_14;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            FileUtils.deleteDirectory((File)dir);
                        }
                        catch (IOException e) {
                            this.log(-1, "Error deleting tmp dir %s: %s", new Object[]{dir, e.getMessage()});
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
        }
        this.log(-1, "given script location not supported or not valid:\n%s", new Object[]{scriptFile});
        return -1;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return "NetworkRunner";
    }

    @Override
    public boolean canHandle(String identifier) {
        String[] parts;
        int protoSepIndex;
        if (identifier != null && (protoSepIndex = identifier.indexOf("://")) > 0 && protoSepIndex <= 5 && (parts = identifier.split("://")).length > 1 && !parts[1].isEmpty()) {
            return null != this.getScriptURL(identifier);
        }
        return false;
    }

    public String resolveRelativeFile(String script) {
        return script;
    }

    private String getScriptURL(String scriptFile) {
        try {
            URL scriptURL = new URL(scriptFile);
            String path = scriptURL.getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            String basename = FilenameUtils.getBaseName((String)path);
            String host = scriptURL.getHost();
            if (host.contains("github.com")) {
                host = "https://raw.githubusercontent.com";
                path = path.replace("tree/", "");
            } else {
                host = scriptFile.substring(0, scriptFile.indexOf(path));
            }
            String identifier = host + path;
            for (IScriptRunner runner : Runner.getRunners()) {
                for (String ending : runner.getFileEndings()) {
                    String url = identifier.endsWith(ending) ? identifier : identifier + "/" + basename + ending;
                    if (FileManager.isUrlUseabel(url) <= 0) continue;
                    return url;
                }
            }
        }
        catch (MalformedURLException e) {
            this.log(-1, "Invalid URL:\n%s", scriptFile);
        }
        return null;
    }

    @Override
    public String[] getExtensions() {
        return new String[0];
    }

    @Override
    public String getType() {
        return "NET";
    }

    @Override
    public boolean isAbortSupported() {
        return this.wrapper.isAbortSupported();
    }

    @Override
    protected void doAbort() {
        this.wrapper.doAbort();
    }

    @Override
    protected void adjustBundlePath(String script, IScriptRunner.Options options) {
        String identifierParent = script.substring(0, script.lastIndexOf("/"));
        ImagePath.addHTTP(identifierParent);
    }

    @Override
    protected void resetBundlePath(String script, IScriptRunner.Options options) {
        String identifierParent = script.substring(0, script.lastIndexOf("/"));
        ImagePath.removeHTTP(identifierParent);
    }
}

