/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.basics.GenericHotkeyManager;
import org.sikuli.basics.HotkeyListener;
import org.sikuli.basics.PreferencesUser;
import org.sikuli.basics.Settings;
import org.sikuli.script.Key;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.support.RunTime;

public abstract class HotkeyManager {
    private static HotkeyManager _instance = null;
    private static Map<String, Integer[]> hotkeys;
    private static Map<String, Integer[]> hotkeysGlobal;
    private static final String HotkeyTypeCapture = "Capture";
    private static int HotkeyTypeCaptureKey;
    private static int HotkeyTypeCaptureMod;
    private static final String HotkeyTypeAbort = "Abort";
    private static int HotkeyTypeAbortKey;
    private static int HotkeyTypeAbortMod;
    private static RunTime runTime;

    public static HotkeyManager getInstance() {
        if (_instance == null) {
            runTime = RunTime.get();
            if (HotkeyManager.runTime.runningWindows || HotkeyManager.runTime.runningMac) {
                _instance = new GenericHotkeyManager();
            } else {
                String cls = HotkeyManager.getOSHotkeyManagerClass();
                if (cls != null) {
                    try {
                        Class<?> c = Class.forName(cls);
                        Constructor<?> constr = c.getConstructor(new Class[0]);
                        _instance = (HotkeyManager)constr.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        Debug.error("HotkeyManager: Can't create " + cls + ": " + e.getMessage(), new Object[0]);
                    }
                }
            }
            hotkeys = new HashMap<String, Integer[]>();
        }
        return _instance;
    }

    public static void reset(boolean isTerminating) {
        if (_instance == null) {
            return;
        }
        int result = HotkeyManager.reset(hotkeys, isTerminating);
        if (result > 0) {
            Debug.log(3, "HotkeyManager: reset: removed all user hotkeys.", new Object[0]);
        }
        if (result < 0 && !isTerminating) {
            throw new SikuliXception(String.format("fatal: HotkeyManager: reset: did not work", new Object[0]));
        }
        if (!isTerminating) {
            return;
        }
        result = HotkeyManager.reset(hotkeysGlobal, isTerminating);
        if (result > 0) {
            Debug.log(3, "HotkeyManager: reset: removed all SikuliX hotkeys.", new Object[0]);
        }
        if (isTerminating) {
            _instance.cleanUp();
        }
    }

    private static int reset(Map<String, Integer[]> hotkeys, boolean isTerminating) {
        int removed = _instance._removeAll(hotkeys, isTerminating);
        hotkeys.clear();
        return removed;
    }

    public abstract void cleanUp();

    private static String getOSHotkeyManagerClass() {
        String pkg = "org.sikuli.basics.";
        if (HotkeyManager.runTime.runningMac) {
            return pkg + "MacHotkeyManager";
        }
        if (HotkeyManager.runTime.runningWindows) {
            return pkg + "WindowsHotkeyManager";
        }
        if (HotkeyManager.runTime.runningLinux) {
            return pkg + "LinuxHotkeyManager";
        }
        Debug.error("HotkeyManager: not supported on your OS.", new Object[0]);
        return null;
    }

    private static String getKeyCodeText(int key) {
        return KeyEvent.getKeyText(key).toUpperCase();
    }

    private static String getKeyModifierText(int modifiers) {
        String txtMod = KeyEvent.getKeyModifiersText(modifiers).toUpperCase();
        if (Settings.isMac()) {
            txtMod = txtMod.replace("META", "CMD");
            txtMod = txtMod.replace("WINDOWS", "CMD");
        } else {
            txtMod = txtMod.replace("META", "WIN");
            txtMod = txtMod.replace("WINDOWS", "WIN");
        }
        return txtMod;
    }

    public boolean addHotkey(String hotkeyType, HotkeyListener callback) {
        PreferencesUser pref = PreferencesUser.get();
        if (hotkeyType == HotkeyTypeCapture) {
            HotkeyTypeCaptureKey = pref.getCaptureHotkey();
            HotkeyTypeCaptureMod = pref.getCaptureHotkeyModifiers();
            return this.installHotkey(HotkeyTypeCaptureKey, HotkeyTypeCaptureMod, callback, hotkeyType);
        }
        if (hotkeyType == HotkeyTypeAbort) {
            HotkeyTypeAbortKey = pref.getStopHotkey();
            HotkeyTypeAbortMod = pref.getStopHotkeyModifiers();
            return this.installHotkey(HotkeyTypeAbortKey, HotkeyTypeAbortMod, callback, hotkeyType);
        }
        Debug.error("HotkeyManager: addHotkey: HotkeyType %s not supported", hotkeyType);
        return false;
    }

    public String getHotKeyText(String hotkeyType) {
        PreferencesUser pref = PreferencesUser.get();
        String key = "";
        String mod = "";
        if (hotkeyType == HotkeyTypeCapture) {
            key = HotkeyManager.getKeyCodeText(pref.getCaptureHotkey());
            mod = HotkeyManager.getKeyModifierText(pref.getCaptureHotkeyModifiers());
        } else if (hotkeyType == HotkeyTypeAbort) {
            key = HotkeyManager.getKeyCodeText(pref.getStopHotkey());
            mod = HotkeyManager.getKeyModifierText(pref.getStopHotkeyModifiers());
        } else {
            Debug.error("HotkeyManager: getHotKeyText: HotkeyType %s not supported", hotkeyType);
        }
        return mod + " " + key;
    }

    public boolean addHotkey(char key, int modifiers, HotkeyListener callback) {
        return this.addHotkey("" + key, modifiers, callback);
    }

    public boolean addHotkey(String key, int modifiers, HotkeyListener callback) {
        int[] keyCodes = Key.toJavaKeyCode(key.toLowerCase());
        int keyCode = keyCodes[0];
        return this.installHotkey(keyCode, modifiers, callback, "");
    }

    private boolean installHotkey(int key, int mod, HotkeyListener callback, String hotkeyType) {
        boolean res;
        String txtMod = HotkeyManager.getKeyModifierText(mod);
        String txtCode = HotkeyManager.getKeyCodeText(key);
        String token = "" + key + mod;
        Debug.log(3, "HotkeyManager: add %s Hotkey: %s %s (%d, %d)", new Object[]{hotkeyType, txtMod, txtCode, key, mod});
        boolean checkGlobal = true;
        if (hotkeys.containsKey(token)) {
            res = _instance._removeHotkey(hotkeys.get(token)[0], hotkeys.get(token)[1]);
            if (!res) {
                Debug.error("HotkeyManager: addHotkey: failed to remove already defined hotkey", new Object[0]);
                return false;
            }
            checkGlobal = false;
        }
        if (checkGlobal) {
            for (String kg : hotkeysGlobal.keySet()) {
                int gkey = hotkeysGlobal.get(kg)[0];
                int gmod = hotkeysGlobal.get(kg)[1];
                if (gkey != key || gmod != mod) continue;
                Debug.error("HotkeyManager: addHotkey: ignored: trying to redefine global hotkey %s", kg);
                return false;
            }
        }
        if (res = _instance._addHotkey(key, mod, callback)) {
            if (hotkeyType.isEmpty()) {
                hotkeys.put(token, new Integer[]{key, mod});
            } else {
                hotkeysGlobal.put(hotkeyType, new Integer[]{key, mod});
            }
        } else {
            Debug.error("HotkeyManager: addHotkey: failed", new Object[0]);
        }
        return res;
    }

    public boolean removeHotkey(String hotkeyType) {
        if (hotkeysGlobal.containsKey(hotkeyType)) {
            return this.uninstallHotkey(hotkeyType);
        }
        Debug.error("HotkeyManager: removeHotkey: HotkeyType %s not defined", hotkeyType);
        return false;
    }

    public boolean removeHotkey(char key, int modifiers) {
        return this.removeHotkey("" + key, modifiers);
    }

    public boolean removeHotkey(String key, int modifiers) {
        int[] keyCodes = Key.toJavaKeyCode(key.toLowerCase());
        int keyCode = keyCodes[0];
        return this.uninstallHotkey(keyCode, modifiers);
    }

    private boolean uninstallHotkey(String type) {
        int gmod;
        int gkey = hotkeysGlobal.get(type)[0];
        boolean success = this.uninstallHotkey(gkey, gmod = hotkeysGlobal.get(type)[1].intValue());
        if (success) {
            hotkeysGlobal.remove(type);
        }
        return success;
    }

    private boolean uninstallHotkey(int key, int mod) {
        String txtMod = HotkeyManager.getKeyModifierText(mod);
        String txtCode = HotkeyManager.getKeyCodeText(key);
        Debug.log("HotkeyManager: remove Hotkey: %s %s (%d, %d)", txtMod, txtCode, key, mod);
        boolean res = _instance._removeHotkey(key, mod);
        if (res) {
            hotkeys.remove(key);
        } else {
            Debug.error("HotkeyManager: removeHotkey: failed", new Object[0]);
        }
        return res;
    }

    public abstract boolean _addHotkey(int var1, int var2, HotkeyListener var3);

    public abstract boolean _removeHotkey(int var1, int var2);

    public abstract int _removeAll(Map<String, Integer[]> var1, boolean var2);

    static {
        hotkeysGlobal = new HashMap<String, Integer[]>();
    }
}

