/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.android;

import java.io.File;
import org.sikuli.android.ADBDevice;
import org.sikuli.android.ADBScreen;
import org.sikuli.basics.Debug;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Image;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Sikulix;
import org.sikuli.script.support.RunTime;

public class ADBTest {
    private static int lvl = 3;
    private static boolean runTests = true;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "ADBTest: " + message, args);
    }

    private static void logp(String message, Object ... args) {
        System.out.println(String.format(message, args));
    }

    public static void main(String[] args) throws FindFailed {
        ADBScreen aScr = ADBTest.startTest();
        if (aScr.isValid()) {
            if (runTests) {
                ADBTest.ideTest(aScr);
            }
            ADBScreen.stop();
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static ADBScreen startTest() {
        Debug.on(3);
        ADBScreen adbs = new ADBScreen();
        if (adbs.isValid()) {
            ADBTest.log(lvl, "Device found: %s", adbs.getDeviceDescription());
            adbs.wakeUp(2);
            adbs.wait(1.0);
            if (!adbs.getDevice().isDisplayOn().booleanValue()) {
                ADBTest.log(-1, "WakeUp did not work", new Object[0]);
            } else {
                adbs.aKey(ADBDevice.KEY_HOME);
                adbs.wait(1.0);
            }
        }
        return adbs;
    }

    private static void basicTest(ADBScreen adbs) throws FindFailed {
        ADBTest.log(lvl, "**************** running basic test", new Object[0]);
        adbs.aSwipeLeft();
        adbs.aSwipeRight();
        adbs.wait(1.0);
        ScreenImage sIMg = adbs.userCapture("Android");
        sIMg.getFile(RunTime.get().fSikulixStore.getAbsolutePath(), "android");
        if (Debug.getDebugLevel() > 2) {
            ADBTest.saveShot();
        }
        adbs.aTap(new Image(sIMg));
    }

    private static void saveShot() {
        if (Debug.getDebugLevel() < 3) {
            return;
        }
        File fShot = new File(RunTime.get().fSikulixStore.getAbsolutePath(), "lastScreenShot.png");
        File fShotAndroid = new File(RunTime.get().fSikulixStore.getAbsolutePath(), "lastScreenAndroid.png");
        if (fShotAndroid.exists()) {
            fShotAndroid.delete();
        }
        if (fShot.exists()) {
            fShot.renameTo(fShotAndroid);
        }
    }

    public static void ideTest(ADBScreen aScr) {
        int debugLevel;
        String title = "Android Support - Testing device";
        Sikulix.popup("Take care\n\nthat device is on and unlocked\n\nbefore clicking ok", title);
        aScr.wakeUp(2);
        aScr.aKey(ADBDevice.KEY_HOME);
        boolean cancelled = true;
        if (Sikulix.popAsk("Now the device should show the HOME screen.\n\nclick YES to proceed watching the test on the device\nclick NO to end the test now", title)) {
            cancelled = false;
            aScr.aSwipeLeft();
            aScr.aSwipeRight();
            aScr.wait(1.0);
            if (Sikulix.popAsk("You should have seen a swipe left and a swipe right.\n\nclick YES to capture an icon from homescreen and then aTap it\nclick NO to end the test now", title)) {
                debugLevel = Debug.getDebugLevel();
                Debug.on(3);
                ScreenImage sIMg = aScr.userCapture("AndroidTest");
                sIMg.getFile(RunTime.get().fSikulixStore.getAbsolutePath(), "android");
                ADBTest.saveShot();
                Debug.on(debugLevel);
                try {
                    aScr.aTap(new Image(sIMg));
                    Sikulix.popup("The image was found on the device's current screen\nand should have been tapped.\n\nIf you think it worked, you can now try\nto capture needed images from the device - be aware:\n\nYou have to come back here and click Default!", title);
                }
                catch (FindFailed findFailed) {
                    Sikulix.popError("Sorry, the image you captured was\nnot found on the device's current screen", title);
                    cancelled = true;
                }
            } else {
                cancelled = true;
            }
        }
        if (cancelled && Sikulix.popAsk("You have cancelled or the image was not found.\n\nclick YES to produce some output for debugging\n... which may take a while !!\nclick NO to simply leave", title)) {
            debugLevel = Debug.getDebugLevel();
            Debug.on(3);
            ADBScreen.stop();
            ADBScreen adbScreen = ADBScreen.start();
            adbScreen.getDevice().printDump();
            ADBScreen.stop();
            Debug.on(debugLevel);
        }
    }
}

