/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.FileUtils;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.util.List;

@NotThreadSafe
public class X509Authentication
extends AbstractAuthenticationMethod {
    static final String METHOD_NAME = "X509";
    static final String METHOD_TICKET_PREFIX = "-----BEGIN";
    private byte[] _serverNonce;
    private String _userName;

    public static String resolveX509FileName(String x509) throws SQLException {
        if (x509.startsWith(METHOD_TICKET_PREFIX)) {
            return x509;
        }
        try {
            x509 = FileUtils.readString(x509, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.x509.readfile", e.getMessage());
        }
        return x509;
    }

    public static String generateJWTTokenForProof(ConnectionSapDB conn, String x509) throws SQLException {
        byte[] signatureOutput;
        long millis = System.currentTimeMillis();
        List<byte[]> keys = Base64Utils.decodePrivateKeys(x509);
        String header = "{\"alg\":\"RS256\",\"typ\":\"JWT\"}";
        String headerBase64 = Base64Utils.encodeToString(header.getBytes(StandardCharsets.UTF_8), true);
        String payload = "{\"iss\":\"" + Driver.getFullComputerName() + "\",\"sub\":\"" + Driver.getProcessID() + "\",\"aud\":\"" + conn.getPrimaryConnectionID() + "\",\"iat\":\"" + millis + "\",\"end\":\"" + (millis + 300000L) + "\"}";
        String payloadBase64 = Base64Utils.encodeToString(payload.getBytes(StandardCharsets.UTF_8), true);
        try {
            PrivateKey privateKey = X509Authentication._createPrivateKeyFromBytes(keys.get(0));
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update((headerBase64 + '.' + payloadBase64).getBytes(StandardCharsets.UTF_8));
            signatureOutput = signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.x509.signingfailed", e.getMessage());
        }
        String signatureBase64 = Base64Utils.encodeToString(signatureOutput, true);
        String proof = headerBase64 + '.' + payloadBase64 + '.' + signatureBase64;
        return proof;
    }

    @Override
    String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    byte[] getInitialData(byte[] passwd) throws SQLException {
        return new byte[0];
    }

    @Override
    byte[] getFinalData(String passwd, String x509) throws SQLException {
        int signatureOutputLengthIndicatorLength;
        int signatureOutputLength;
        byte[] signatureOutput;
        int i;
        int totalChainCertificatesLength;
        int[] chainCertificateLengthIndicatorLengths;
        int[] chainCertificateLengths;
        byte[][] chainCertificates;
        List<byte[]> keys = Base64Utils.decodePrivateKeys(x509);
        List<byte[]> certs = Base64Utils.decodeCertificates(x509);
        if (keys.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.connection.x509.missingprivatekey", new String[0]);
        }
        if (certs.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.connection.x509.missingcertificates", new String[0]);
        }
        for (byte[] cert : certs) {
            X509Authentication._validateCertificate(cert);
        }
        byte[] ownCertificate = certs.get(0);
        int ownCertificateLength = ownCertificate.length;
        int ownCertificateLengthIndicatorLength = HAuthenticationPart.getLengthIndicatorLength(ownCertificateLength);
        int chainCertificateCount = certs.size() - 1;
        if (chainCertificateCount > 0) {
            chainCertificates = new byte[chainCertificateCount][];
            chainCertificateLengths = new int[chainCertificateCount];
            chainCertificateLengthIndicatorLengths = new int[chainCertificateCount];
            totalChainCertificatesLength = 2;
            for (int i2 = 0; i2 < chainCertificateCount; ++i2) {
                chainCertificates[i2] = certs.get(i2 + 1);
                chainCertificateLengths[i2] = chainCertificates[i2].length;
                chainCertificateLengthIndicatorLengths[i2] = HAuthenticationPart.getLengthIndicatorLength(chainCertificateLengths[i2]);
                totalChainCertificatesLength += chainCertificateLengthIndicatorLengths[i2] + chainCertificateLengths[i2];
            }
        } else {
            chainCertificates = null;
            chainCertificateLengths = null;
            chainCertificateLengthIndicatorLengths = null;
            totalChainCertificatesLength = 0;
        }
        int totalChainCertificatesLengthIndicatorLength = HAuthenticationPart.getLengthIndicatorLength(totalChainCertificatesLength);
        try {
            PrivateKey privateKey = X509Authentication._createPrivateKeyFromBytes(keys.get(0));
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(ownCertificate);
            for (i = 0; i < chainCertificateCount; ++i) {
                signature.update(chainCertificates[i]);
            }
            signature.update(this._serverNonce);
            signatureOutput = signature.sign();
            signatureOutputLength = signatureOutput.length;
            signatureOutputLengthIndicatorLength = HAuthenticationPart.getLengthIndicatorLength(signatureOutputLength);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.x509.signingfailed", e.getMessage());
        }
        int totalLength = 2 + ownCertificateLengthIndicatorLength + ownCertificateLength + totalChainCertificatesLengthIndicatorLength + totalChainCertificatesLength + signatureOutputLengthIndicatorLength + signatureOutputLength;
        byte[] bytes = new byte[totalLength];
        int offset = 0;
        ByteUtils.putShort(3, bytes, offset);
        HAuthenticationPart.putLengthIndicator(ownCertificateLength, bytes, offset += 2);
        ByteUtils.putBytes(ownCertificate, bytes, offset += ownCertificateLengthIndicatorLength);
        HAuthenticationPart.putLengthIndicator(totalChainCertificatesLength, bytes, offset += ownCertificateLength);
        offset += totalChainCertificatesLengthIndicatorLength;
        if (chainCertificateCount > 0) {
            ByteUtils.putShort(chainCertificateCount, bytes, offset);
            offset += 2;
            for (i = 0; i < chainCertificateCount; ++i) {
                HAuthenticationPart.putLengthIndicator(chainCertificateLengths[i], bytes, offset);
                ByteUtils.putBytes(chainCertificates[i], bytes, offset += chainCertificateLengthIndicatorLengths[i]);
                offset += chainCertificateLengths[i];
            }
        }
        HAuthenticationPart.putLengthIndicator(signatureOutputLength, bytes, offset);
        ByteUtils.putBytes(signatureOutput, bytes, offset += signatureOutputLengthIndicatorLength);
        offset += signatureOutputLength;
        return bytes;
    }

    @Override
    byte[] evaluateAuthenticateReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        this._serverNonce = authenticationPart.getValueAsBytes();
        return null;
    }

    @Override
    String evaluateConnectReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        HAuthenticationPart part = new HAuthenticationPart(authenticationPart);
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        this._userName = part.getValueAsString();
        if (tracer.on()) {
            tracer.printDebugMessage("X509 Authentication: User: " + this._userName);
        }
        if (!part.nextField()) {
            return null;
        }
        String sessionCookie = part.getValueAsString();
        if (tracer.on()) {
            tracer.printDebugMessage("X509 Authentication: Received session cookie");
        }
        return sessionCookie;
    }

    @Override
    String getUserNameFromServer() {
        return this._userName;
    }

    private static PrivateKey _createPrivateKeyFromBytes(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        PrivateKey key = factory.generatePrivate(keySpec);
        return key;
    }

    private static void _validateCertificate(byte[] certBytes) throws SQLException {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate certificate = factory.generateCertificate(new ByteArrayInputStream(certBytes));
            if (certificate instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                x509Certificate.checkValidity();
            }
        }
        catch (CertificateExpiredException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.x509.expiredcertificate", new String[0]);
        }
        catch (CertificateNotYetValidException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.x509.notyetvalidcertificate", new String[0]);
        }
        catch (CertificateException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.x509.invalidcertificate", new String[0]);
        }
    }
}

