/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HashPartitionInfo;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PartitionParameterInfo;
import com.sap.db.jdbc.RangeInfo;
import com.sap.db.jdbc.RangePartitionInfo;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteReplicaVolumeID;
import com.sap.db.jdbc.SiteTypeReplicaRoleVolumeID;
import com.sap.db.jdbc.SystemInfo;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.RTEInvalidPacketException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.ClientSideEncryptionVersion;
import com.sap.db.jdbc.packet.DBConnectInfo;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.ErrorLevel;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.HPartIterable;
import com.sap.db.jdbc.packet.HReadLOBReplyPart;
import com.sap.db.jdbc.packet.HSegmentIterable;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.packet.PacketOption;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.packet.PartitionMethod;
import com.sap.db.jdbc.packet.PartitionParameterFunction;
import com.sap.db.jdbc.packet.RangeComparisonFunction;
import com.sap.db.jdbc.packet.SessionReattachOption;
import com.sap.db.jdbc.packet.SessionReattachStatusOption;
import com.sap.db.jdbc.packet.XATransactionInfoOption;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.HanaXid;
import com.sap.db.jdbcext.XAExceptionSAP;
import com.sap.db.jdbcext.XidSAP;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.UUIDUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

@ThreadSafe
public class HReplyPacket {
    private static final ThreadLocal<PacketAnalyzer> PACKET_ANALYZER = ThreadLocal.withInitial(PacketAnalyzer::new);
    private final byte[] _packet;
    private final Segment[] _segments;
    private final boolean _asciiStringOptimization;

    public static HReplyPacket newInstance(Tracer tracer, Session session, byte[] packet) throws RTEException {
        PacketAnalyzer packetAnalyzer = PACKET_ANALYZER.get();
        int packetLength = PacketAnalyzer.align(packet.length);
        packetAnalyzer.parse(packet);
        short segmentCount = packetAnalyzer.getSegmentCount();
        if (segmentCount < 0) {
            HReplyPacket._throwInvalidPacket(tracer, session, "Segment count is " + segmentCount);
        }
        Segment[] segments = new Segment[segmentCount];
        int segmentIndex = 0;
        while (packetAnalyzer.nextSegment()) {
            int segmentLength;
            short partCount = packetAnalyzer.getPartCount();
            if (partCount < 0) {
                HReplyPacket._throwInvalidPacket(tracer, session, "Part count for segment " + segmentIndex + " is " + partCount);
            }
            Part[] parts = new Part[partCount];
            int partIndex = 0;
            while (packetAnalyzer.nextPart()) {
                int partLength;
                int partOffset = packetAnalyzer.getPartOffset();
                if (partOffset < 0 || partOffset > packetLength) {
                    HReplyPacket._throwInvalidPacket(tracer, session, "Part offset for segment " + segmentIndex + ", part " + partIndex + " is " + partOffset);
                }
                if ((partLength = packetAnalyzer.getPartLength()) < 0 || partOffset + partLength > packetLength) {
                    HReplyPacket._throwInvalidPacket(tracer, session, "Part length for segment " + segmentIndex + ", part " + partIndex + " is " + partLength);
                }
                parts[partIndex] = new Part(packetAnalyzer.getPartOffset(), packetAnalyzer.getPartLength());
                ++partIndex;
            }
            int segmentOffset = packetAnalyzer.getSegmentOffset();
            if (segmentOffset < 0 || segmentOffset > packetLength) {
                HReplyPacket._throwInvalidPacket(tracer, session, "Segment offset for segment " + segmentIndex + " is " + segmentOffset);
            }
            if ((segmentLength = packetAnalyzer.getSegmentLength()) < 0 || segmentOffset + segmentLength > packetLength) {
                HReplyPacket._throwInvalidPacket(tracer, session, "Segment length for segment " + segmentIndex + " is " + segmentLength);
            }
            segments[segmentIndex] = new Segment(segmentOffset, segmentLength, parts);
            ++segmentIndex;
        }
        packetAnalyzer.clear();
        return new HReplyPacket(packet, segments, session != null ? session.asciiStringOptimization() : Boolean.parseBoolean(ConnectionProperty.ASCII_STRING_OPTIMIZATION.getDefaultValue()));
    }

    public static String getVariableLengthString(byte[] packet, boolean asciiStringOptimization, boolean lenientCESU8, int[] inoutParmOffset) {
        boolean isNull;
        int length;
        int pos = inoutParmOffset[0];
        int lengthIndicator = ByteUtils.getUByte(packet, pos);
        ++pos;
        switch (lengthIndicator) {
            case 246: {
                length = ByteUtils.getShort(packet, pos);
                isNull = false;
                pos += 2;
                break;
            }
            case 247: {
                length = ByteUtils.getInt(packet, pos);
                isNull = false;
                pos += 4;
                break;
            }
            case 255: {
                length = 0;
                isNull = true;
                break;
            }
            default: {
                if (lengthIndicator <= 245) {
                    length = lengthIndicator;
                    isNull = false;
                    break;
                }
                throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
            }
        }
        inoutParmOffset[0] = isNull ? pos : pos + length;
        return isNull ? null : Cesu8Utils.getString(packet, pos, length, asciiStringOptimization, lenientCESU8);
    }

    private HReplyPacket(byte[] packet, Segment[] segments, boolean asciiStringOptimization) {
        this._packet = packet;
        this._segments = segments;
        this._asciiStringOptimization = asciiStringOptimization;
    }

    public int getLength() {
        return this._packet.length;
    }

    public int getSegmentCount() {
        return this._segments.length;
    }

    public int getPartCount(int segmentIndex) {
        return this._segments[segmentIndex]._parts.length;
    }

    public HSegmentIterable segments() {
        return new HSegmentIterable(this);
    }

    public HPartIterable parts(int segmentIndex) {
        return new HPartIterable(this, segmentIndex);
    }

    public Set<PacketOption> getPacketOptions() {
        return PacketOption.decode(ByteUtils.getByte(this._packet, 22));
    }

    public FunctionCode getFunctionCode(int segmentIndex) {
        return FunctionCode.decode(ByteUtils.getShort(this._packet, this._segments[segmentIndex]._offset + 14));
    }

    public PartKind getPartKind(int segmentIndex, int partIndex) {
        Part part = this._segments[segmentIndex]._parts[partIndex];
        return PartKind.decode(ByteUtils.getByte(this._packet, part._offset + 0));
    }

    public HAuthenticationPart getAuthenticationPart(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.Authentication);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        return new HAuthenticationPart(this._packet, part._offset + 16, part._length, this._asciiStringOptimization);
    }

    public DBConnectInfo getDBConnectInfo(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.DBConnectInfo);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        return new DBConnectInfo(new HOptionsPart(this._packet, part._offset, 16 + part._length, this._asciiStringOptimization));
    }

    public SessionReattachStatusOption getServerReattachStatus(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.SessionReattach);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        HOptionsPart optionsPart = new HOptionsPart(this._packet, part._offset, 16 + part._length, this._asciiStringOptimization);
        do {
            switch (SessionReattachOption.decode(optionsPart.getOptionName())) {
                case ServerReattachStatus: {
                    return SessionReattachStatusOption.decode(optionsPart.getOptionIntValue());
                }
            }
        } while (optionsPart.nextOption());
        return null;
    }

    public int getErrorCode(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.Error);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        int errorCode = ByteUtils.getInt(this._packet, part._offset + 16);
        return errorCode;
    }

    public SQLException getSQLExceptionChain(ConnectionSapDB conn, int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.Error);
        return this._buildExceptionChain(conn, segmentIndex, partIndex);
    }

    public byte[] getStatementID(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.StatementID);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        byte[] statementID = ByteUtils.getBytes(this._packet, part._offset + 16, part._length);
        return statementID;
    }

    public byte[] getTransactionID(int segmentIndex, int partIndex, byte[] buffer) {
        this._checkPartType(segmentIndex, partIndex, PartKind.TransactionID);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        byte[] transactionID = ByteUtils.getBytes(this._packet, part._offset + 16, part._length, buffer);
        return transactionID;
    }

    public byte[] getCursorID(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.ResultSetID);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        byte[] cursor = ByteUtils.getBytes(this._packet, part._offset + 16, part._length);
        return cursor;
    }

    public int getRowsAffected(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.RowsAffected);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        int rowsAffected = ByteUtils.getInt(this._packet, part._offset + 16);
        return rowsAffected;
    }

    public int[] getBatchUpdateCounts(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.RowsAffected);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        int n = PacketAnalyzer.getArgumentCount(this._packet, part._offset);
        int[] updateCounts = new int[n];
        for (int i = 0; i < n; ++i) {
            updateCounts[i] = ByteUtils.getInt(this._packet, part._offset + 16 + i * 4);
        }
        return updateCounts;
    }

    public List<SiteTypeReplicaRoleVolumeID> getTableLocations(int segmentIndex, int partIndex, ConnectionSapDB connection, SystemInfo systemInfo) {
        this._checkPartType(segmentIndex, partIndex, PartKind.TableLocation);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        int n = PacketAnalyzer.getArgumentCount(this._packet, part._offset);
        ArrayList<SiteTypeReplicaRoleVolumeID> tableLocations = new ArrayList<SiteTypeReplicaRoleVolumeID>(n);
        for (int i = 0; i < n; ++i) {
            int siteReplicaVolumeID = ByteUtils.getInt(this._packet, part._offset + 16 + i * 4);
            SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID = SiteTypeReplicaRoleVolumeID.newInstance(siteReplicaVolumeID, systemInfo);
            this._traceUnknownSiteReplicaVolumeID(connection, siteTypeReplicaRoleVolumeID);
            tableLocations.add(siteTypeReplicaRoleVolumeID);
        }
        return tableLocations;
    }

    public PartitionMethod getPartitionMethod(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.PartitionInformation);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        PartitionMethod partitionMethod = PartitionMethod.decode(ByteUtils.getByte(this._packet, part._offset + 16));
        return partitionMethod;
    }

    public HashPartitionInfo getHashPartitionInfo(int segmentIndex, int partIndex, ConnectionSapDB connection, SystemInfo systemInfo) {
        this._checkPartType(segmentIndex, partIndex, PartKind.PartitionInformation);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        PartitionMethod partitionMethod = PartitionMethod.decode(ByteUtils.getByte(this._packet, part._offset + 16));
        if (partitionMethod != PartitionMethod.Hash && partitionMethod != PartitionMethod.HashWithoutSplitBatch) {
            return null;
        }
        int off = part._offset + 16;
        int rangeCount = ByteUtils.getInt(this._packet, off + 4);
        int parameterCount = ByteUtils.getInt(this._packet, off + 8);
        int partitionCount = ByteUtils.getInt(this._packet, off + 12);
        List<PartitionParameterInfo> partitionParameterInfoList = this._getPartitionParameterInfoList(part, parameterCount);
        Map<Integer, List<SiteTypeReplicaRoleVolumeID>> partitionAssignmentMap = this._getHashPartitionVolumeIDAssignments(part, parameterCount, partitionCount, connection, systemInfo);
        return new HashPartitionInfo(partitionMethod, partitionParameterInfoList, partitionAssignmentMap, rangeCount, parameterCount, partitionCount);
    }

    public RangePartitionInfo getRangePartitionInfo(int segmentIndex, int partIndex, ConnectionSapDB connection, SystemInfo systemInfo) {
        this._checkPartType(segmentIndex, partIndex, PartKind.PartitionInformation);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        PartitionMethod partitionMethod = PartitionMethod.decode(ByteUtils.getByte(this._packet, part._offset + 16));
        if (partitionMethod != PartitionMethod.Range && partitionMethod != PartitionMethod.RangeWithoutSplitBatch) {
            return null;
        }
        int off = part._offset + 16;
        int rangeCount = ByteUtils.getInt(this._packet, off + 4);
        int parameterCount = ByteUtils.getInt(this._packet, off + 8);
        int partitionCount = ByteUtils.getInt(this._packet, off + 12);
        HashMap<String, Boolean> attributeTypes = new HashMap<String, Boolean>();
        attributeTypes.put("isLongType", false);
        attributeTypes.put("isStringType", false);
        attributeTypes.put("isBigDecimalType", false);
        List<PartitionParameterInfo> partitionParameterInfoList = this._getPartitionParameterInfoList(part, parameterCount, attributeTypes);
        List<RangeInfo> rangeInfoList = this._getRangeInfoList(part, parameterCount, rangeCount, connection, systemInfo, attributeTypes);
        return new RangePartitionInfo(partitionMethod, partitionParameterInfoList, rangeInfoList, rangeCount, parameterCount, partitionCount);
    }

    public int getXAReturnCode(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.XOpen_XATransactionInfo);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        HOptionsPart optionsPart = new HOptionsPart(this._packet, part._offset, 16 + part._length, this._asciiStringOptimization);
        do {
            switch (XATransactionInfoOption.decode(optionsPart.getOptionName())) {
                case ReturnCode: {
                    return optionsPart.getOptionIntValue();
                }
            }
        } while (optionsPart.nextOption());
        return 0;
    }

    public Xid[] getXids(int segmentIndex, int partIndex) throws XAException {
        this._checkPartType(segmentIndex, partIndex, PartKind.XOpen_XATransactionInfo);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        HOptionsPart optionsPart = new HOptionsPart(this._packet, part._offset, 16 + part._length, this._asciiStringOptimization);
        int xidCount = 0;
        Xid[] xids = null;
        block4: do {
            switch (XATransactionInfoOption.decode(optionsPart.getOptionName())) {
                case NumberOfXID: {
                    long xidCountLong = optionsPart.getOptionLongValue();
                    if (xidCountLong >= Integer.MAX_VALUE) {
                        throw new XAException("Too many Xids in reply: " + xidCount);
                    }
                    xidCount = (int)xidCountLong;
                    break;
                }
                case XIDList: {
                    if (xidCount <= 0) continue block4;
                    int optionOffset = optionsPart.getCurrentOffset();
                    short optionValueLength = ByteUtils.getShort(this._packet, part._offset + optionOffset + 2);
                    if (optionValueLength != 140 * xidCount) {
                        throw new XAExceptionSAP(-4, "Wrong Xid length: expected =" + 140 * xidCount + "; actual =" + optionValueLength);
                    }
                    xids = new XidSAP[xidCount];
                    int i = 0;
                    int offset = part._offset + optionOffset + 4;
                    while (i < xidCount) {
                        int formatId = ByteUtils.getInt(this._packet, offset);
                        int globalTransactionIdSize = ByteUtils.getInt(this._packet, offset + 4);
                        int branchQualifierSize = ByteUtils.getInt(this._packet, offset + 8);
                        byte[] globalTransactionId = ByteUtils.getBytes(this._packet, offset + 12, globalTransactionIdSize);
                        byte[] branchQualifier = ByteUtils.getBytes(this._packet, offset + 12 + globalTransactionIdSize, branchQualifierSize);
                        xids[i] = new HanaXid(formatId, globalTransactionId, branchQualifier);
                        ++i;
                        offset += 140;
                    }
                    break block0;
                }
            }
        } while (optionsPart.nextOption());
        return xids != null ? xids : new XidSAP[]{};
    }

    public byte[][] getLOBLocators(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.WriteLOBReply);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        int n = PacketAnalyzer.getArgumentCount(this._packet, part._offset);
        byte[][] locators = new byte[n][];
        for (int i = 0; i < n; ++i) {
            locators[i] = ByteUtils.getBytes(this._packet, part._offset + 16 + 8 * i, 8);
        }
        return locators;
    }

    public void getResultSetMetaData(int segmentIndex, int partIndex, ConnectionSapDB connection, List<AbstractConverter> converters) throws SQLException {
        int i;
        this._checkPartType(segmentIndex, partIndex, PartKind.ResultSetMetaData);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        int columnCount = PacketAnalyzer.getArgumentCount(this._packet, part._offset);
        int identOffset = part._offset + 16 + columnCount * 24;
        EngineFeatures engineFeatures = connection.getEngineFeatures();
        boolean[] isEncrypted = new boolean[columnCount];
        boolean[] isDeterministic = new boolean[columnCount];
        ColumnEncryptionKey[] ceks = new ColumnEncryptionKey[columnCount];
        converters.clear();
        if (engineFeatures.getClientSideEncryptionVersion().getValue() >= ClientSideEncryptionVersion.Level1.getValue()) {
            int encryptionOffset = identOffset;
            for (i = 0; i < columnCount; ++i) {
                byte encryptionOptions = ByteUtils.getByte(this._packet, encryptionOffset + 0);
                if ((encryptionOptions & 1) != 0) {
                    isEncrypted[i] = true;
                    isDeterministic[i] = (encryptionOptions & 2) == 0;
                    String cekId = UUIDUtils.newInstance(this._packet, encryptionOffset + 1).toString();
                    ceks[i] = connection.retrieveColumnEncryptionKey(cekId);
                    encryptionOffset += 17;
                    continue;
                }
                ++encryptionOffset;
            }
            identOffset = encryptionOffset;
        }
        i = 0;
        int metaDataOffset = part._offset + 16;
        while (i < columnCount) {
            int outputFieldPos;
            Set<ParameterOption> parameterOptions = ParameterOption.decode(ByteUtils.getByte(this._packet, metaDataOffset + 0));
            DataType dataType = DataType.decode(ByteUtils.getByte(this._packet, metaDataOffset + 1));
            short fraction = ByteUtils.getShort(this._packet, metaDataOffset + 2);
            int length = dataType == DataType.REAL_VECTOR || dataType == DataType.HALF_VECTOR ? ByteUtils.getUnsignedShort(this._packet, metaDataOffset + 4) : (int)ByteUtils.getShort(this._packet, metaDataOffset + 4);
            int offset = ByteUtils.getInt(this._packet, metaDataOffset + 8);
            String tableName = offset != -1 ? Cesu8Utils.getString(this._packet, identOffset + offset + 1, ByteUtils.getUByte(this._packet, identOffset + offset), this._asciiStringOptimization, false) : "";
            offset = ByteUtils.getInt(this._packet, metaDataOffset + 12);
            String schemaName = offset != -1 ? Cesu8Utils.getString(this._packet, identOffset + offset + 1, ByteUtils.getUByte(this._packet, identOffset + offset), this._asciiStringOptimization, false) : "";
            offset = ByteUtils.getInt(this._packet, metaDataOffset + 16);
            String columnName = offset != -1 ? Cesu8Utils.getString(this._packet, identOffset + offset + 1, ByteUtils.getUByte(this._packet, identOffset + offset), this._asciiStringOptimization, false) : "";
            offset = ByteUtils.getInt(this._packet, metaDataOffset + 20);
            String columnLabel = offset != -1 ? Cesu8Utils.getString(this._packet, identOffset + offset + 1, ByteUtils.getUByte(this._packet, identOffset + offset), this._asciiStringOptimization, false) : "";
            ParameterMode parameterMode = ParameterMode.Out;
            int index = outputFieldPos = i + 1;
            int inputFieldPos = -1;
            converters.add(AbstractConverter.newInstance(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted[i], ceks[i], isDeterministic[i]));
            ++i;
            metaDataOffset += 24;
        }
    }

    public void getParameterMetaData(int segmentIndex, int partIndex, ConnectionSapDB connection, ParseInfo parseInfo) throws SQLException {
        int i;
        this._checkPartType(segmentIndex, partIndex, PartKind.ParameterMetaData);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        int parameterCount = PacketAnalyzer.getArgumentCount(this._packet, part._offset);
        int identOffset = part._offset + 16 + parameterCount * 16;
        EngineFeatures engineFeatures = connection.getEngineFeatures();
        boolean[] isEncrypted = new boolean[parameterCount];
        boolean[] isDeterministic = new boolean[parameterCount];
        ColumnEncryptionKey[] ceks = new ColumnEncryptionKey[parameterCount];
        ArrayList<AbstractConverter> converters = new ArrayList<AbstractConverter>();
        ArrayList<DataType> outputDataTypes = new ArrayList<DataType>();
        int inputParameterCount = 0;
        int outputParameterCount = 0;
        boolean hasInputLOB = false;
        boolean hasOutputLOB = false;
        if (engineFeatures.getClientSideEncryptionVersion().getValue() >= ClientSideEncryptionVersion.Level1.getValue()) {
            int encryptionOffset = identOffset;
            for (i = 0; i < parameterCount; ++i) {
                byte encryptionOptions = ByteUtils.getByte(this._packet, encryptionOffset + 0);
                if ((encryptionOptions & 1) != 0) {
                    isEncrypted[i] = true;
                    isDeterministic[i] = (encryptionOptions & 2) == 0;
                    String cekId = UUIDUtils.newInstance(this._packet, encryptionOffset + 1).toString();
                    ceks[i] = connection.retrieveColumnEncryptionKey(cekId);
                    encryptionOffset += 17;
                    continue;
                }
                ++encryptionOffset;
            }
            identOffset = encryptionOffset;
        }
        i = 0;
        int metaDataOffset = part._offset + 16;
        while (i < parameterCount) {
            int outputFieldPos;
            int inputFieldPos;
            Set<ParameterOption> parameterOptions = ParameterOption.decode(ByteUtils.getByte(this._packet, metaDataOffset + 0));
            DataType dataType = DataType.decode(ByteUtils.getByte(this._packet, metaDataOffset + 1));
            boolean isLOB = dataType.isLOB();
            ParameterMode parameterMode = ParameterMode.decode(ByteUtils.getByte(this._packet, metaDataOffset + 2));
            int offset = ByteUtils.getInt(this._packet, metaDataOffset + 4);
            String parameterName = offset != -1 ? Cesu8Utils.getString(this._packet, identOffset + offset + 1, ByteUtils.getUByte(this._packet, identOffset + offset), this._asciiStringOptimization, false) : "";
            int length = dataType == DataType.REAL_VECTOR || dataType == DataType.HALF_VECTOR ? ByteUtils.getUnsignedShort(this._packet, metaDataOffset + 8) : (int)ByteUtils.getShort(this._packet, metaDataOffset + 8);
            short fraction = ByteUtils.getShort(this._packet, metaDataOffset + 10);
            int index = i + 1;
            switch (parameterMode) {
                case In: {
                    inputFieldPos = ++inputParameterCount;
                    outputFieldPos = -1;
                    hasInputLOB |= isLOB;
                    break;
                }
                case Out: {
                    inputFieldPos = -1;
                    outputFieldPos = ++outputParameterCount;
                    outputDataTypes.add(dataType);
                    hasOutputLOB |= isLOB;
                    break;
                }
                case Inout: {
                    inputFieldPos = ++inputParameterCount;
                    outputFieldPos = ++outputParameterCount;
                    outputDataTypes.add(dataType);
                    hasInputLOB |= isLOB;
                    hasOutputLOB |= isLOB;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected parameter mode: " + (Object)((Object)parameterMode)));
                }
            }
            converters.add(AbstractConverter.newInstance(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, "", "", parameterName, parameterName, isEncrypted[i], ceks[i], isDeterministic[i]));
            ++i;
            metaDataOffset += 16;
        }
        parseInfo.setParameterInfo(converters, inputParameterCount, outputDataTypes, hasInputLOB, hasOutputLOB);
    }

    public Map<String, String> getSessionVariables(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.SessionVariable);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        int n = PacketAnalyzer.getArgumentCount(this._packet, part._offset);
        int[] inoutParmOffset = new int[]{part._offset + 16};
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            String key = HReplyPacket.getVariableLengthString(this._packet, this._asciiStringOptimization, false, inoutParmOffset);
            String val = HReplyPacket.getVariableLengthString(this._packet, this._asciiStringOptimization, false, inoutParmOffset);
            map.put(key, val);
        }
        return map;
    }

    public HOptionsPart getOptionsPart(int segmentIndex, int partIndex) {
        this._checkOptionsPart(segmentIndex, partIndex);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        return new HOptionsPart(this._packet, part._offset, 16 + part._length, this._asciiStringOptimization);
    }

    public HMultiLineOptionsPart getMultiLineOptionsPart(int segmentIndex, int partIndex) {
        this._checkMultiLineOptionsPart(segmentIndex, partIndex);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        return new HMultiLineOptionsPart(this._packet, part._offset, 16 + part._length, this._asciiStringOptimization);
    }

    public HDataPart getResultSetPart(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.ResultSet);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        return HDataPart.createResultSetPart(this._packet, part._offset, 16 + part._length, this._asciiStringOptimization);
    }

    public HDataPart getOutputParametersPart(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.OutputParameters);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        return HDataPart.createOutputParametersPart(this._packet, part._offset, 16 + part._length, this._asciiStringOptimization);
    }

    public HReadLOBReplyPart getReadLOBReplyPart(int segmentIndex, int partIndex) {
        this._checkPartType(segmentIndex, partIndex, PartKind.ReadLOBReply);
        Part part = this._segments[segmentIndex]._parts[partIndex];
        return new HReadLOBReplyPart(this._packet, part._offset, 16 + part._length, this._asciiStringOptimization);
    }

    public HAuthenticationPart findAuthenticationPart(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.Authentication);
        return partIndex != -1 ? this.getAuthenticationPart(segmentIndex, partIndex) : null;
    }

    public DBConnectInfo findDBConnectInfo(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.DBConnectInfo);
        return partIndex != -1 ? this.getDBConnectInfo(segmentIndex, partIndex) : null;
    }

    public HOptionsPart findSessionReattachPart(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.SessionReattach);
        return partIndex != -1 ? this.getOptionsPart(segmentIndex, partIndex) : null;
    }

    public SessionReattachStatusOption findServerReattachStatus(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.SessionReattach);
        return partIndex != -1 ? this.getServerReattachStatus(segmentIndex, partIndex) : null;
    }

    public int findErrorCode(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.Error);
        return partIndex != -1 ? this.getErrorCode(segmentIndex, partIndex) : 0;
    }

    public SQLException findSQLExceptionChain(ConnectionSapDB conn, int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.Error);
        return partIndex != -1 ? this.getSQLExceptionChain(conn, segmentIndex, partIndex) : null;
    }

    public byte[] findTransactionID(int segmentIndex, byte[] buffer) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.TransactionID);
        return partIndex != -1 ? this.getTransactionID(segmentIndex, partIndex, buffer) : null;
    }

    public int findRowsAffected(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.RowsAffected);
        return partIndex != -1 ? this.getRowsAffected(segmentIndex, partIndex) : -1;
    }

    public int[] findBatchUpdateCounts(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.RowsAffected);
        return partIndex != -1 ? this.getBatchUpdateCounts(segmentIndex, partIndex) : new int[]{};
    }

    public HOptionsPart findStatementContextPart(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.StatementContext);
        return partIndex != -1 ? this.getOptionsPart(segmentIndex, partIndex) : null;
    }

    public int findXAReturnCode(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.XOpen_XATransactionInfo);
        return partIndex != -1 ? this.getXAReturnCode(segmentIndex, partIndex) : 0;
    }

    public Xid[] findXids(int segmentIndex) throws XAException {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.XOpen_XATransactionInfo);
        return partIndex != -1 ? this.getXids(segmentIndex, partIndex) : new XidSAP[]{};
    }

    public byte[][] findLOBLocators(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.WriteLOBReply);
        return partIndex != -1 ? (Object)this.getLOBLocators(segmentIndex, partIndex) : new byte[][]{};
    }

    public HDataPart findResultSetPart(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.ResultSet);
        return partIndex != -1 ? this.getResultSetPart(segmentIndex, partIndex) : null;
    }

    public HDataPart findOutputParametersPart(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.OutputParameters);
        return partIndex != -1 ? this.getOutputParametersPart(segmentIndex, partIndex) : null;
    }

    public HReadLOBReplyPart findReadLOBReplyPart(int segmentIndex) {
        int partIndex = this._findPartIndex(segmentIndex, PartKind.ReadLOBReply);
        return partIndex != -1 ? this.getReadLOBReplyPart(segmentIndex, partIndex) : null;
    }

    private static void _throwInvalidPacket(Tracer tracer, Session session, String errText) throws RTEException {
        throw RTEInvalidPacketException.newInstance(tracer, session, MessageTranslator.translate("error.packet.invalid", errText), RteReturnCode.REQUEST_UNKNOWN);
    }

    private void _checkPartType(int segmentIndex, int partIndex, PartKind expectedPartKind) {
        Part part = this._segments[segmentIndex]._parts[partIndex];
        PartKind partKind = PartKind.decode(ByteUtils.getByte(this._packet, part._offset + 0));
        if (partKind != expectedPartKind) {
            throw new AssertionError((Object)("Unexpected part kind: " + (Object)((Object)expectedPartKind) + " != " + (Object)((Object)partKind)));
        }
    }

    private void _checkOptionsPart(int segmentIndex, int partIndex) {
        PartKind partKind = this.getPartKind(segmentIndex, partIndex);
        switch (partKind) {
            case DBConnectInfo: 
            case StatementContext: 
            case ConnectOptions: 
            case TransactionFlags: 
            case XOpen_XATransactionInfo: 
            case SessionCookie: 
            case SessionReattach: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected part kind: " + (Object)((Object)partKind) + " is not an options part"));
            }
        }
    }

    private void _checkMultiLineOptionsPart(int segmentIndex, int partIndex) {
        PartKind partKind = this.getPartKind(segmentIndex, partIndex);
        switch (partKind) {
            case TopologyInformation: 
            case SQLReplyOptions: 
            case PrintOptions: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected part kind: " + (Object)((Object)partKind) + " is not a multi-line options part"));
            }
        }
    }

    private int _findPartIndex(int segmentIndex, PartKind partKind) {
        if (this._segments.length == 0) {
            return -1;
        }
        Part[] parts = this._segments[segmentIndex]._parts;
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            Part part = parts[i];
            if (ByteUtils.getByte(this._packet, part._offset + 0) != partKind.getValue()) continue;
            return i;
        }
        return -1;
    }

    private SQLException _buildExceptionChain(ConnectionSapDB conn, int segmentIndex, int partIndex) {
        Part errorPart = this._segments[segmentIndex]._parts[partIndex];
        int errorCount = PacketAnalyzer.getArgumentCount(this._packet, errorPart._offset);
        int[] updateCounts = this.findBatchUpdateCounts(segmentIndex);
        SQLException ret = null;
        int i = 0;
        int offset = errorPart._offset + 16;
        while (i < errorCount) {
            int errorCode = ByteUtils.getInt(this._packet, offset + 0);
            int errorPosition = ByteUtils.getInt(this._packet, offset + 4);
            int errorTextLength = ByteUtils.getInt(this._packet, offset + 8);
            byte errorLevel = ByteUtils.getByte(this._packet, offset + 12);
            String sqlState = Cesu8Utils.getString(this._packet, offset + 13, 5, conn.asciiStringOptimization(), false);
            String errorText = Cesu8Utils.getString(this._packet, offset + 18, errorTextLength, conn.asciiStringOptimization(), true);
            int argumentLength = 19 + errorTextLength;
            if (!sqlState.equals("HY000") || errorCode != 1039) {
                if (errorLevel == ErrorLevel.Warning.getValue()) {
                    return new SQLWarning(errorText, sqlState, errorCode);
                }
                SQLException e = errorPosition > 1 ? SQLExceptionSapDB.newInstance(conn, "error.databaseexception", sqlState, errorCode, errorPosition, RteReturnCode.SQLOK, updateCounts, String.valueOf(errorCode), String.valueOf(errorPosition), errorText) : SQLExceptionSapDB.newInstance(conn, "error.databaseexception.woerrpos", sqlState, errorCode, errorPosition, RteReturnCode.SQLOK, updateCounts, String.valueOf(errorCode), errorText);
                if (ret == null) {
                    ret = e;
                } else {
                    ret.setNextException(e);
                }
            }
            ++i;
            offset += PacketAnalyzer.align(argumentLength);
        }
        return ret;
    }

    private List<PartitionParameterInfo> _getPartitionParameterInfoList(Part part, int parameterCount) {
        ArrayList<PartitionParameterInfo> partitionParameterInfoList = new ArrayList<PartitionParameterInfo>();
        int i = 0;
        int offset = part._offset + 16 + 16;
        while (i < parameterCount) {
            int parameterIndex = ByteUtils.getInt(this._packet, offset);
            PartitionParameterFunction partitionParameterFunction = PartitionParameterFunction.decode(ByteUtils.getByte(this._packet, offset + 4));
            byte attributeType = ByteUtils.getByte(this._packet, offset + 5);
            RangeComparisonFunction rangeComparisonFunction = RangeComparisonFunction.decode(ByteUtils.getByte(this._packet, offset + 6));
            PartitionParameterInfo partitionParamInfo = new PartitionParameterInfo(parameterIndex, partitionParameterFunction, attributeType, rangeComparisonFunction);
            partitionParameterInfoList.add(partitionParamInfo);
            ++i;
            offset += 8;
        }
        return partitionParameterInfoList;
    }

    private List<PartitionParameterInfo> _getPartitionParameterInfoList(Part part, int parameterCount, Map<String, Boolean> attributeTypes) {
        ArrayList<PartitionParameterInfo> partitionParameterInfoList = new ArrayList<PartitionParameterInfo>();
        int i = 0;
        int offset = part._offset + 16 + 16;
        while (i < parameterCount) {
            int parameterIndex = ByteUtils.getInt(this._packet, offset);
            PartitionParameterFunction partitionParameterFunction = PartitionParameterFunction.decode(ByteUtils.getByte(this._packet, offset + 4));
            byte attributeType = ByteUtils.getByte(this._packet, offset + 5);
            RangeComparisonFunction rangeComparisonFunction = RangeComparisonFunction.decode(ByteUtils.getByte(this._packet, offset + 6));
            switch (attributeType) {
                case 64: 
                case 68: 
                case 73: 
                case 101: 
                case 115: {
                    attributeTypes.put("isLongType", true);
                    break;
                }
                case 66: {
                    attributeTypes.put("isLongType", true);
                    attributeTypes.put("isBigDecimalType", true);
                    break;
                }
                case 67: 
                case 83: {
                    attributeTypes.put("isStringType", true);
                    break;
                }
                case 77: {
                    attributeTypes.put("isBigDecimalType", true);
                }
            }
            PartitionParameterInfo partitionParamInfo = new PartitionParameterInfo(parameterIndex, partitionParameterFunction, attributeType, rangeComparisonFunction);
            partitionParameterInfoList.add(partitionParamInfo);
            ++i;
            offset += 8;
        }
        return partitionParameterInfoList;
    }

    private Map<Integer, List<SiteTypeReplicaRoleVolumeID>> _getHashPartitionVolumeIDAssignments(Part part, int parameterCount, int partitionCount, ConnectionSapDB connection, SystemInfo systemInfo) {
        TreeMap<Integer, List<SiteTypeReplicaRoleVolumeID>> partitionAssignmentMap = new TreeMap<Integer, List<SiteTypeReplicaRoleVolumeID>>();
        int offset = part._offset + 16 + 16 + 8 * parameterCount;
        for (int i = 0; i < partitionCount; ++i) {
            SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID;
            int partitionNumber = ByteUtils.getInt(this._packet, offset);
            int siteReplicaVolumeID = ByteUtils.getInt(this._packet, offset + 4);
            ArrayList<SiteTypeReplicaRoleVolumeID> siteTypeReplicaRoleVolumeIDs = (ArrayList<SiteTypeReplicaRoleVolumeID>)partitionAssignmentMap.get(partitionNumber);
            if (siteTypeReplicaRoleVolumeIDs == null) {
                siteTypeReplicaRoleVolumeIDs = new ArrayList<SiteTypeReplicaRoleVolumeID>();
                partitionAssignmentMap.put(partitionNumber, siteTypeReplicaRoleVolumeIDs);
            }
            if (this._isMultiVolume(siteReplicaVolumeID)) {
                int numberOfAggregateVolumesForPartition = this._getVolumeCount(siteReplicaVolumeID);
                offset += 8;
                int j = 0;
                while (j < numberOfAggregateVolumesForPartition) {
                    int aSiteReplicaVolumeID = ByteUtils.getInt(this._packet, offset);
                    siteTypeReplicaRoleVolumeID = SiteTypeReplicaRoleVolumeID.newInstance(aSiteReplicaVolumeID, systemInfo, true);
                    this._traceUnknownSiteReplicaVolumeID(connection, siteTypeReplicaRoleVolumeID);
                    siteTypeReplicaRoleVolumeIDs.add(siteTypeReplicaRoleVolumeID);
                    ++j;
                    offset += 4;
                }
                offset = PacketAnalyzer.align(offset);
                continue;
            }
            siteTypeReplicaRoleVolumeID = SiteTypeReplicaRoleVolumeID.newInstance(siteReplicaVolumeID, systemInfo, true);
            this._traceUnknownSiteReplicaVolumeID(connection, siteTypeReplicaRoleVolumeID);
            siteTypeReplicaRoleVolumeIDs.add(siteTypeReplicaRoleVolumeID);
            offset += 8;
        }
        return partitionAssignmentMap;
    }

    private boolean _isMultiVolume(int siteReplicaVolumeID) {
        return (siteReplicaVolumeID & Integer.MIN_VALUE) != 0;
    }

    private int _getVolumeCount(int siteReplicaVolumeID) {
        if (this._isMultiVolume(siteReplicaVolumeID)) {
            return siteReplicaVolumeID & Integer.MAX_VALUE;
        }
        return 1;
    }

    private List<RangeInfo> _getRangeInfoList(Part part, int parameterCount, int rangeCount, ConnectionSapDB connection, SystemInfo systemInfo, Map<String, Boolean> attributeTypes) {
        ArrayList<RangeInfo> rangeInfoList = new ArrayList<RangeInfo>();
        int offset = part._offset + 16 + 16 + 8 * parameterCount;
        for (int i = 0; i < rangeCount; ++i) {
            ArrayList<SiteTypeReplicaRoleVolumeID> siteTypeReplicaRoleVolumeIDs = new ArrayList<SiteTypeReplicaRoleVolumeID>();
            offset += this._getRangeSiteTypeReplicaRoleVolumeIDs(siteTypeReplicaRoleVolumeIDs, offset, connection, systemInfo);
            byte multiValueRange = ByteUtils.getByte(this._packet, offset++);
            int floorDataLengthIndicator = ByteUtils.getByte(this._packet, offset) & 0xFF;
            int[] floorStringOffset = new int[1];
            int[] ceilStringOffset = new int[1];
            int floorLength = this._getRangeLengthAndRangeStringValueOffset(floorDataLengthIndicator, offset, floorStringOffset);
            offset = floorStringOffset[0] + (floorLength != -1 ? floorLength : 1);
            int ceilDataLengthIndicator = ByteUtils.getByte(this._packet, offset) & 0xFF;
            int ceilLength = this._getRangeLengthAndRangeStringValueOffset(ceilDataLengthIndicator, offset, ceilStringOffset);
            offset = ceilStringOffset[0] + (ceilLength != -1 ? ceilLength : 1);
            RangeInfo rangeInfo = this._getRangeInfo(multiValueRange, floorLength, floorStringOffset, ceilLength, ceilStringOffset, attributeTypes, siteTypeReplicaRoleVolumeIDs);
            rangeInfoList.add(rangeInfo);
            offset = PacketAnalyzer.align(offset);
        }
        return rangeInfoList;
    }

    private int _getRangeSiteTypeReplicaRoleVolumeIDs(List<SiteTypeReplicaRoleVolumeID> siteTypeReplicaRoleVolumeIDs, int offset, ConnectionSapDB connection, SystemInfo systemInfo) {
        int offsetOriginal = offset;
        int siteReplicaVolumeID = ByteUtils.getInt(this._packet, offset);
        if (this._isMultiVolume(siteReplicaVolumeID)) {
            int numberOfAggregateVolumesForPartition = this._getVolumeCount(siteReplicaVolumeID);
            offset += 4;
            int j = 0;
            while (j < numberOfAggregateVolumesForPartition) {
                int aSiteReplicaVolumeID = ByteUtils.getInt(this._packet, offset);
                SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID = SiteTypeReplicaRoleVolumeID.newInstance(aSiteReplicaVolumeID, systemInfo, true);
                this._traceUnknownSiteReplicaVolumeID(connection, siteTypeReplicaRoleVolumeID);
                siteTypeReplicaRoleVolumeIDs.add(siteTypeReplicaRoleVolumeID);
                ++j;
                offset += 4;
            }
        } else {
            SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID = SiteTypeReplicaRoleVolumeID.newInstance(siteReplicaVolumeID, systemInfo, true);
            this._traceUnknownSiteReplicaVolumeID(connection, siteTypeReplicaRoleVolumeID);
            siteTypeReplicaRoleVolumeIDs.add(siteTypeReplicaRoleVolumeID);
            offset += 4;
        }
        return offset - offsetOriginal;
    }

    private int _getRangeLengthAndRangeStringValueOffset(int dataLengthIndicator, int offset, int[] stringOffset) {
        int length;
        switch (dataLengthIndicator) {
            case 247: {
                length = ByteUtils.getInt(this._packet, offset++);
                stringOffset[0] = offset + 4;
                break;
            }
            case 246: {
                length = ByteUtils.getShort(this._packet, offset++);
                stringOffset[0] = offset + 2;
                break;
            }
            case 255: {
                length = -1;
                stringOffset[0] = offset;
                break;
            }
            default: {
                length = dataLengthIndicator;
                stringOffset[0] = offset + 1;
            }
        }
        return length;
    }

    private RangeInfo _getRangeInfo(byte multiValueRange, int floorLength, int[] floorStringOffset, int ceilLength, int[] ceilStringOffset, Map<String, Boolean> attributeTypes, List<SiteTypeReplicaRoleVolumeID> siteTypeReplicaRoleVolumeIDs) {
        String ceil;
        boolean restRange = floorLength == -1 && ceilLength == -1;
        String stringFloor = null;
        String stringCeil = null;
        long longFloor = -1L;
        long longCeil = -1L;
        BigDecimal bdFloor = null;
        BigDecimal bdCeil = null;
        String floor = floorLength > 0 ? Cesu8Utils.getString(this._packet, floorStringOffset[0], floorLength, this._asciiStringOptimization, false) : "";
        String string = ceil = ceilLength > 0 ? Cesu8Utils.getString(this._packet, ceilStringOffset[0], ceilLength, this._asciiStringOptimization, false) : "";
        if (attributeTypes.get("isStringType").booleanValue()) {
            stringFloor = floor;
            if (ceilLength > 0) {
                stringCeil = ceil;
            }
        }
        if (attributeTypes.get("isLongType").booleanValue()) {
            try {
                longFloor = Long.parseLong(floor);
                if (ceilLength > 0) {
                    longCeil = Long.parseLong(ceil);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (attributeTypes.get("isBigDecimalType").booleanValue()) {
            try {
                bdFloor = new BigDecimal(floor);
                if (ceilLength > 0) {
                    bdCeil = new BigDecimal(ceil);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new RangeInfo(siteTypeReplicaRoleVolumeIDs, multiValueRange, restRange, stringFloor, stringCeil, longFloor, longCeil, bdFloor, bdCeil);
    }

    private void _traceUnknownSiteReplicaVolumeID(ConnectionSapDB connection, SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID) {
        SiteReplicaVolumeID unknownSiteReplicaVolumeID;
        if (connection == null) {
            return;
        }
        Tracer tracer = connection.getTracer();
        if (tracer.on() && (unknownSiteReplicaVolumeID = siteTypeReplicaRoleVolumeID.getUnknownSiteReplicaVolumeID()) != null) {
            tracer.printDistribution(connection, "Unknown SiteReplicaVolumeID " + unknownSiteReplicaVolumeID);
        }
    }

    protected int _findPartIndex(PartKind partKind) {
        return this._findPartIndex(0, partKind);
    }

    private static class Segment {
        private final int _offset;
        private final int _length;
        private final Part[] _parts;

        private Segment(int offset, int length, Part[] parts) {
            this._offset = offset;
            this._length = length;
            this._parts = parts;
        }

        public String toString() {
            return this._offset + ":" + this._length + "(" + this._parts.length + ")";
        }
    }

    private static class Part {
        private final int _offset;
        private final int _length;

        private Part(int offset, int length) {
            this._offset = offset;
            this._length = length;
        }

        public String toString() {
            return this._offset + ":" + this._length;
        }
    }
}

