/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class HalfConverter
extends AbstractNumericConverter {
    public static final Float MIN_VALUE = Float.valueOf(-65504.0f);
    public static final Float MAX_VALUE = Float.valueOf(65504.0f);

    protected HalfConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, false, null, true);
    }

    @Override
    public int getEstimatedColumnSize() {
        throw new AssertionError((Object)"Unexpected invocation");
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        throw new AssertionError((Object)"Unexpected invocation");
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        throw new AssertionError((Object)"Unexpected invocation");
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsFloat(dataPart, outIsNull);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return String.valueOf(this._getValueAsFloat(dataPart, null));
    }

    private float _getValueAsFloat(HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        if (outIsNull != null) {
            outIsNull[0] = false;
        }
        return dataPart.getHalfAsFloat();
    }
}

