/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ArraySapDB;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaArray;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class ArrayConverter
extends AbstractConverter {
    protected final DataType _elementType;
    protected final AbstractConverter _elementConverter;

    protected ArrayConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, DataType elementType, AbstractConverter elementConverter) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, false, null, true);
        this._elementType = elementType;
        this._elementConverter = elementConverter;
    }

    @Override
    public int getEstimatedColumnSize() {
        return 5000;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        throw new AssertionError((Object)"Not implemented");
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        throw new AssertionError((Object)"Not implemented");
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsArray(controller, dataPart, false);
    }

    @Override
    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart);
    }

    @Override
    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] bytes = this._getValueAsByteArray(controller, dataPart);
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    @Override
    public Array getArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsArray(controller, dataPart, false);
    }

    protected Array _getValueAsArray(SQLParamController controller, HDataPart dataPart, boolean forRealOrHalfVector) throws SQLException {
        if (dataPart.isNull(this, controller)) {
            return null;
        }
        int elementCount = dataPart.getIntAsInt();
        Object[] elements = ArraySapDB.newArray(this._elementType, elementCount);
        HDataPart data = HDataPart.createArrayPart(dataPart, this._outputFieldPos, this._elementConverter);
        int n = elementCount;
        for (int i = 0; i < n; ++i) {
            data.moveToField(i + 1);
            this._setArrayElement(controller, data, elements, i);
        }
        if (!forRealOrHalfVector) {
            controller.setNullIndicator(DataFormatDescription.NullIndicator.NOT_NULL);
        }
        return new HanaArray(this._connection, this._elementType, elements);
    }

    protected void _setArrayElement(SQLParamController controller, HDataPart data, Object[] elements, int idx) throws SQLException {
        switch (this._elementType) {
            case BOOLEAN: {
                Boolean element = this._elementConverter.getBoolean(controller, data, null);
                elements[idx] = controller.wasNullOrSpecialNull() ? null : element;
                break;
            }
            case TINYINT: 
            case SMALLINT: {
                Short element = this._elementConverter.getShort(controller, data, null);
                elements[idx] = controller.wasNullOrSpecialNull() ? null : element;
                break;
            }
            case INT: {
                Integer element = this._elementConverter.getInt(controller, data, null);
                elements[idx] = controller.wasNullOrSpecialNull() ? null : element;
                break;
            }
            case BIGINT: {
                Long element = this._elementConverter.getLong(controller, data, null);
                elements[idx] = controller.wasNullOrSpecialNull() ? null : element;
                break;
            }
            case REAL: {
                Float element = Float.valueOf(this._elementConverter.getFloat(controller, data, null));
                elements[idx] = controller.wasNullOrSpecialNull() ? null : element;
                break;
            }
            case DOUBLE: {
                Double element = this._elementConverter.getDouble(controller, data, null);
                elements[idx] = controller.wasNullOrSpecialNull() ? null : element;
                break;
            }
            case DECIMAL: 
            case FIXED8: 
            case FIXED12: 
            case FIXED16: {
                elements[idx] = this._elementConverter.getBigDecimal(controller, data);
                break;
            }
            case DATE: 
            case DAYDATE: {
                elements[idx] = this._elementConverter.getDate(controller, data, null);
                break;
            }
            case TIME: 
            case SECONDTIME: {
                elements[idx] = this._elementConverter.getTime(controller, data, null);
                break;
            }
            case TIMESTAMP: 
            case SECONDDATE: 
            case LONGDATE: {
                elements[idx] = this._elementConverter.getTimestamp(controller, data, null);
                break;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case STRING: 
            case NSTRING: 
            case VARCHAR2: 
            case ALPHANUM: {
                elements[idx] = this._elementConverter.getString(controller, data);
                break;
            }
            case BINARY: 
            case VARBINARY: 
            case BSTRING: {
                elements[idx] = this._elementConverter.getBytes(controller, data);
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.method.unsupported", "ArrayConverter", this._elementType.getDisplayName() + " as element data type of array");
            }
        }
    }

    private byte[] _getValueAsByteArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(this, controller) ? null : dataPart.getBinaryAsBytes();
    }
}

