/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import java.util.HashMap;
import java.util.Map;

@Immutable
public final class SMVRRole
implements Comparable<SMVRRole> {
    public static final SMVRRole NONE = new SMVRRole("NONE", 0, 1);
    public static final SMVRRole SOURCE = new SMVRRole("SOURCE", 1, 1);
    public static final SMVRRole REPLICA = new SMVRRole("REPLICA", 2, 2);
    private static final Map<Integer, SMVRRole> SMVR_ROLE_MAP = new HashMap<Integer, SMVRRole>();
    private final String _displayString;
    private final int _value;
    private final int _compareValue;

    public static String getDisplayString(int value) {
        SMVRRole smvrRole = SMVR_ROLE_MAP.get(value);
        return smvrRole != null ? smvrRole._displayString : "UNKNOWN(" + value + ")";
    }

    public static SMVRRole decode(int value) {
        SMVRRole smvrRole = SMVR_ROLE_MAP.get(value);
        return smvrRole != null ? smvrRole : NONE;
    }

    public static SMVRRole decode(String value) {
        if (value == null || value.isEmpty()) {
            return NONE;
        }
        SMVRRole smvrRole = (value = value.trim()).equalsIgnoreCase("SOURCE") ? SOURCE : (value.equalsIgnoreCase("REPLICA") ? REPLICA : NONE);
        return smvrRole;
    }

    private SMVRRole(String displayString, int value, int compareValue) {
        this._displayString = displayString;
        this._value = value;
        this._compareValue = compareValue;
    }

    @Override
    public int compareTo(SMVRRole other) {
        return this._compareValue - other._compareValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SMVRRole)) {
            return false;
        }
        SMVRRole other = (SMVRRole)object;
        return this._compareValue == other._compareValue;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._compareValue;
        return result;
    }

    public String toString() {
        return this._displayString;
    }

    public int getValue() {
        return this._value;
    }

    static {
        for (SMVRRole smvrRole : new SMVRRole[]{NONE, SOURCE, REPLICA}) {
            SMVR_ROLE_MAP.put(smvrRole._value, smvrRole);
        }
    }
}

